/**
 * @file	cmmidioutmt32sound.cpp
 * @brief	MIDI OUT MT32Sound NX̓̒`s܂
 */

#include "compiler.h"
#include "cmmidioutmt32sound.h"

#if defined(MT32SOUND_DLL)

#include "ext\mt32snd.h"

/**
 * CX^X쐬
 * @return CX^X
 */
CComMidiOutMT32Sound* CComMidiOutMT32Sound::CreateInstance()
{
	MT32Sound* pMT32Sound = MT32Sound::GetInstance();
	if (!pMT32Sound->Open())
	{
		return NULL;
	}
	return new CComMidiOutMT32Sound(pMT32Sound);
}

/**
 * RXgN^
 * @param[in] pMT32Sound nh
 */
CComMidiOutMT32Sound::CComMidiOutMT32Sound(MT32Sound* pMT32Sound)
	: m_pMT32Sound(pMT32Sound)
{
	::sound_streamregist(m_pMT32Sound, reinterpret_cast<SOUNDCB>(GetPcm));
}

/**
 * fXgN^
 */
CComMidiOutMT32Sound::~CComMidiOutMT32Sound()
{
	m_pMT32Sound->Close();
}

/**
 * V[g bZ[W
 * @param[in] nMessage bZ[W
 */
void CComMidiOutMT32Sound::Short(UINT32 nMessage)
{
	sound_sync();
	m_pMT32Sound->ShortMsg(nMessage);
}

/**
 * O bZ[W
 * @param[in] lpMessage bZ[W |C^
 * @param[in] cbMessage bZ[W TCY
 */
void CComMidiOutMT32Sound::Long(const UINT8* lpMessage, UINT cbMessage)
{
	sound_sync();
	m_pMT32Sound->LongMsg(lpMessage, cbMessage);
}

/**
 * vZX
 * @param[in] pMT32Sound nh
 * @param[out] lpBuffer obt@
 * @param[in] nBufferCount Tv
 */
void SOUNDCALL CComMidiOutMT32Sound::GetPcm(MT32Sound* pMT32Sound, SINT32* lpBuffer, UINT nBufferCount)
{
	pMT32Sound->Mix(lpBuffer, nBufferCount);
}

#endif	// defined(MT32SOUND_DLL)
