/*-
 * Copyright (c) 1999 Thomas Runge (coto@core.de)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <X11/Intrinsic.h>

#include "version_check.h"
#include "radio.h"

extern int debug;
extern XtAppContext app_con;

static XtIntervalId fetchtimerId = -1;
static int fetch_cmd_pid;

static void checkReturnedValue();

static void child_handler()
{
	pid_t child_pid;
	int status;

	if(debug)
		printf("Waiting for dead child\n");

	child_pid = wait(&status);

	if(debug)
		printf("child was pid: %d (returned %d).\n", child_pid, status);
	checkReturnedValue();
}

static void timeout_handler(XtPointer clientData, XtIntervalId *id)
{   
	if(fetch_cmd_pid != -1)
	{
		if(debug)
			printf("timer went by, killing unsuccessful version check\n");
		kill(fetch_cmd_pid, SIGINT);
		fetch_cmd_pid = -1;
		checkReturnedValue();
	}
	else
		if(debug)
			printf("timer went by\n");
}

void CheckNewVersion()
{
	fetchtimerId = XtAppAddTimeOut(app_con, CHECKTIMEOUT,
									timeout_handler, (XtPointer)NULL);

	version_enable_button(False);
	signal(SIGALRM, (void*) checkReturnedValue);
	signal(SIGCHLD, (void*) child_handler);
	if((fetch_cmd_pid = fork()) == -1)
	{
		perror("fork");
		return;
	}
	else if(fetch_cmd_pid == 0)
	{
		/* child process */
		chdir("/tmp");
		if(execl(FTP_COMMAND, "xmradio_fetch_version",
#ifdef __NetBSD__
					"-f",
#endif
					"-V", HOMEURL CHECKVERSION) == -1)
		{
			perror("exec");
		}
		kill(getppid(), SIGALRM);
		if(debug)
			printf("Child exiting.\n");
		exit(EXIT_SUCCESS);
	}
	else
	{
		/* parent */
		if(debug)
			printf("Parent returning.\n");
		return;
	}
}


static void checkReturnedValue()
{
	char *ver;
	int ret = 0;
	char *ret_string;
	FILE *fp;
	char buf[512];

    if(debug)
        printf("got signal from child!\n");

	XtRemoveTimeOut(fetchtimerId);
	version_enable_button(True);

	ver = (char*)malloc(strlen(CHECKVERSION) + 6);
	sprintf(ver, "/tmp/%s", CHECKVERSION);

	fp = fopen(ver, "r");
	if(fp)
	{
		if(fgets(buf, 512, fp) != NULL)
			ret_string = strdup(buf);

		fclose(fp);
		unlink(ver);
	}
	else
	{
		ret_string = strdup("Probably a network error.");
		ret = -1;
	}

	free(ver);
	version_check(ret, ret_string);
}

