.\"
.\" @(#)xmmix.man	3.2 96/07/14
.\"
.\"   xmmix - Motif(tm) Audio Mixer
.\"
.\"   Copyright (C) 1994-1996  Ti Kan
.\"   E-mail: ti@amb.org
.\"
.\"   This program is free software; you can redistribute it and/or modify
.\"   it under the terms of the GNU General Public License as published by
.\"   the Free Software Foundation; either version 2 of the License, or
.\"   (at your option) any later version.
.\"
.\"   This program is distributed in the hope that it will be useful,
.\"   but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"   GNU General Public License for more details.
.\"
.\"   You should have received a copy of the GNU General Public License
.\"   along with this program; if not, write to the Free Software
.\"   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.TH XMMIX 1 "14 July 1996" "v1.2"

.SH "NAME"
xmmix \- Audio mixer utility for X11/Motif

.SH "SYNOPSIS"
.B xmmix
.nh
[\fItoolkitoption ...] [-\fIdev\fP device]
[-\fIautoload\fP path] [-\fIexitreset\fP]
[-\fIdebug\fP] [-\fIdemo\fP]

.SH "DESCRIPTION"
.I Xmmix
is a program that allows the use of the mixer section
of the sound card hardware supported by the VoxWare
driver.  See the README file in the
.I xmmix
distribution for further information about VoxWare.
.PP
There are up to ten input level sliders
(Synth, PCM, Alt PCM, Line, Line-1, Line-2, Line-3,
Mic, CD) and up to four
output level sliders (Rec Mon, Rec Out, Speaker and Master).
The Input Gain control, Output Gain control,
Bass and Treble tone control sliders are also available.
Each of the level sliders include a "lock"
toggle button which allows the settings of the two stereo
channels to be changed simultaneously or independently.
The input controls also include a "rec" button (where
applicable), which allows the input sources to be selected
for recording.  The tone control sliders have a "Flat"
button which causes these controls to revert to the
center setting.  In addition, these controls are
available: a "Mute" button to silence the audio, a "Loudness"
button to engage frequency response compensation, and an
"Stereo Enhance" button to set the stereo separation
enhancement.
.PP
.I Xmmix
queries the capabilities of the sound board
during start-up, and will only display controls corresponding to
features that are actually implemented in the hardware.
.PP
The various controls in the
.I xmmix
main window are meant to be self explanatory.  Additional
features include the ability to save mixer settings
in a file and load it at a later time.  A "Reset" feature
resets all controls to their start-up settings.
.PP
While the use of a mouse is natural with
.I xmmix,
all functionality can also be operated via the keyboard.
This is in conformance to the guidelines published in the
.I OSF/Motif Style Guide
from the Open Software Foundation.

.SH "OPTIONS"
All standard \fIXt Intrinsics\fR toolkit options are supported.
In addition,
.I xmmix
supports the following options:
.TP
.I \-dev\ device
.br
Specifies the path name to the raw mixer device.  If this option is
not used, the default device used is
.I /dev/mixer.
.TP
.I \-autoload\ path
.br
Specifies the path name to a mixer settings file that is automatically
loaded when xmmix starts.  This forces all control settings to those
specified in the file.  If this option is not used, then the control
settings will be queried from the mixer hardware itself.  This option
overrides the \fIXMmix*autoLoadOnStartUp\fP X resource.
.TP
.I \-exitreset
Causes all mixer controls to reset to their start-up state when
xmmix is exiting.  This option overrides the \fIXMmix*resetOnExit\fP
X resource.
.TP
.I \-debug
Causes verbose debugging diagnostics to be printed on \fIstderr\fR.
.TP
.I \-demo
Invokes
.I xmmix
in "demo" mode.  This causes
.I xmmix
to display all controls as if they are functional,
but does not actually operate the sound hardware.

.SH "X RESOURCES"
.I Xmmix
has many adjustable X resources to customize its look and feel, as well
as its behavior.  Notably, the colors of virtually every feature on
\fIxmmix\fP's windows can be changed, as well as the text fonts.
.PP
The resource names and their defaults can be found in the
\fBLIBDIR\fI/app-defaults/XMmix\fR
file (where LIBDIR is typically \fI/usr/lib/X11\fP).
It is not recommended
that you change values in the \fBLIBDIR\fI/app-defaults/XMmix\fR file,
unless you want the changes to be forced upon all users of
.I xmmix
on the system.  Instead, make a copy of this file, change the copy as you
see fit, then place it in your home directory.  Your custom resource
settings will then override the defaults when
.I xmmix
is subsequently started.  Alternatively, you may also place specific
resources you wish to override in the
.I .Xdefaults
file in your home directory.

.SH "SEE ALSO"
X(1).

.SH "AUTHOR"
Ti Kan (\fIti@amb.org\fR)
.br
AMB Research Laboratories, Sunnyvale, CA, U.S.A.
.PP
Comments, suggestions, and bug reports are always welcome.
