/*
 *   appenv - Common header file for xmmix.
 *
 *	xmmix  - Motif(tm) Audio Mixer
 *
 *   Copyright (C) 1994-1996  Ti Kan
 *   E-mail: ti@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __APPENV_H__
#define __APPENV_H__

#ifndef LINT
static char *_appenv_h_ident_ = "@(#)appenv.h	3.2 96/07/14";
#endif


/* Whether STATIC should really be... */
#ifdef DEBUG
#define STATIC
#else
#define STATIC		static
#endif


/* Include needed X11 and Motif headers */
#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/MessageB.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/Protocols.h>
#include <X11/Xatom.h>


/* Common header files to be included for all modules */
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/soundcard.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>


/* Program name */
#define PROGNAME	"xmmix"


/* Data type definitions */
typedef char		bool_t;			/* Boolean */


/* Boolean flags */
#ifndef FALSE
#define FALSE		0
#endif
#ifndef TRUE
#define TRUE		1
#endif


/* Constant definitions */
#define STR_BUF_SZ	64		/* Generic string buffer size */

typedef struct {
	char		*device;	/* Device path */
	char		*helppath;	/* Help file path */
	char		*autoload;	/* Auto load on startUp flag */
	bool_t		demo;		/* Demo flag */
	bool_t		debug;		/* Debug flag */
	bool_t		exitreset;	/* Reset on exit flag */
} appdata_t;

#endif	/* __APPENV_H__ */

