/*----------------------------------------------------------------------------
--
--  Module:           xitParSet
--
--  Project:          xit   - X Internal Toolkit
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface for module xitParSet.
--
--  Filename:         xitParSet.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-05-31
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitParSet.h, Version: 1.1, Date: 95/02/18 15:10:43 */


/* Only include this module once. */
#ifndef define_xitParSet_h
#  define define_xitParSet_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XIT_PS_REASON_OK,
  XIT_PS_REASON_CANCEL,
  XIT_PS_REASON_DESTROY
} XIT_PS_REASON;

/* Callback when the summary window is destroyed. */
typedef void ( *XIT_PS_ACTION_CB ) ( XIT_PS_REASON, void * );

/* Tyoes of parameters we can do. */
typedef enum {
  XIT_PS_TYPE_INTEGER,
  XIT_PS_TYPE_YES_NO,
  XIT_PS_TYPE_YES_NO_FLAG,
  XIT_PS_TYPE_ON_OFF,
  XIT_PS_TYPE_ON_OFF_FLAG,
  XIT_PS_TYPE_TEXT_FIELD,
  XIT_PS_TYPE_INTEGER_FIELD,
  XIT_PS_TYPE_DATE_FIELD,
  XIT_PS_TYPE_TIME_FIELD,
  XIT_PS_TYPE_DURATION_FIELD,
  XIT_PS_TYPE_COLOR_FIELD,
  XIT_PS_TYPE_SELECT_FIELD,
  XIT_PS_TYPE_COLOR_INDEX_FIELD,
  XIT_PS_TYPE_SELECT_INDEX_FIELD,
  XIT_PS_TYPE_DATE_FORMAT_FIELD,
  XIT_PS_TYPE_TIME_FORMAT_FIELD,
  XIT_PS_TYPE_HIDDEN_TEXT_FIELD,
  XIT_PS_TYPE_WORKDAYS_FIELD,
  XIT_PS_TYPE_SEPARATOR
} XIT_PS_PAR_TYPES;

/* Strings to use in the parameter window. */
typedef struct {
  char  *window_title;
  char  *parameter_list;
  char  *description;
  char  *parameter_value;
  char  *yes_label;
  char  *no_label;
  char  *on_label;
  char  *off_label;
  char  *msg_confirm_default;
  char  *msg_confirm_reset;
  char  *msg_invalid_value;
  char  *cancel_button;
  char  *defaults_button;
  char  *ok_button;
  char  *reset_button;
  char  *date_order_label;
  char  *mdy_label;
  char  *dmy_label;
  char  *ymd_label;
  char  *date_sep_label;
  char  *day_zero_label;
  char  *month_zero_label;
  char  *century_label;
  char  *hour12_label;
  char  *hour24_label;
  char  *time_sep_label;
  char  *hour_zero_label;
  char  *week_1st_day_label;
  char  *week_1st_days;
  char  *change_button;
  char  *change_hidden_label;
  char  *weekdays_short;
} XIT_PS_LABELS;

/* Structure for one parameter. */
typedef struct {
  char              *parameter_label;
  char              *parameter_help;
  XIT_PS_PAR_TYPES  parameter_type;
  int               min;
  int               max;
  int               max_columns;
  int               max_length;
  char              *select_values;
  UINT32            flag_offset;
  void              *value;
  void              *default_value;
  size_t            size;
} XIT_PAR_REC;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget
  xitCreateParameterSet( Widget            parent,
                         UINT32            flags,
                         XIT_PS_LABELS     *labels,
                         XIT_PS_ACTION_CB  actionCB,
                         XtPointer         user_data );

void
  xitParameterSetDisplay( Widget       parSetW,
                          XIT_PAR_REC  par_rec_ref[],
                          int          rec_no );

#endif
