/*----------------------------------------------------------------------------
--
--  Module:           xitCreLaStr
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Creates a label gadget.
--
--  Filename:         xitCreLaStr.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitCreLaStr.c, Version: 1.1, Date: 95/02/18 15:10:24";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/LabelG.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget 
  xitCreateLabelStruct( Widget            parent,
                        XIT_LABEL_STRUCT  *label_ref )
{

  /* Variables. */
  Arg         args[ 5 ];
  Cardinal    n;
  Widget      label;
  XmString    xstr = NULL;


  /* Code. */

  n = 0;

  if( strlen( label_ref -> string ) > 0 ) {
    xstr = XmStringCreateLtoR( label_ref -> string, CS );
    XtSetArg( args[ n ], XmNlabelString, xstr ); n++;
  }

  if( label_ref -> alignment >= 0 ) {
    XtSetArg( args[ n ], XmNalignment, label_ref -> alignment ); n++;
  }

  label = XmCreateLabelGadget( parent, label_ref -> name, args, n );

  if( strlen( label_ref -> string ) > 0 )
    XmStringFree( xstr );

  return( label );

} /* xitCreateLabelStruct */
