/*----------------------------------------------------------------------------
--
--  Module:           xitCreCascPu
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Creates a cascade button widget.
--
--  Filename:         xitCreCascPu.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitCreCascPu.c, Version: 1.1, Date: 95/02/18 15:10:23";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/CascadeB.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget 
  xitCreateCascadeButton( Widget              parent,
                          Widget              submenu,
                          XIT_CASCADE_STRUCT  *cascade )
{

  /* Variables. */
  Arg         args[ 5 ];
  Cardinal    n;
  Widget      w;
  XmString    xstr = NULL;


  /* Code. */

  n = 0;

  if( strlen( cascade -> title ) > 0 ) {
    xstr = XmStringCreate( cascade -> title, CS );
    XtSetArg( args[ n ], XmNlabelString, xstr ); n++;
  }

  if( strlen( cascade -> mnemonic ) > 0 ) {
    XtSetArg( args[ n ], XmNmnemonic, *cascade -> mnemonic ); n++;
  }

  if( submenu != NULL ) {
    XtSetArg( args[ n ], XmNsubMenuId, submenu ); n++;
  }

  w = XmCreateCascadeButton( parent, cascade -> name, args, n );

  if( xstr != NULL )
    XmStringFree( xstr );


  return( w );

} /* xitCreateCascadeButton */
