/*----------------------------------------------------------------------------
--
--  Module:           xitAttach
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Attaches a widget to it's four sides.
--
--  Filename:         xitAttach.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitAttach.c, Version: 1.1, Date: 95/02/18 15:10:18";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void 
  xitAttachWidget( Widget  widget,
                   int     action_top,
                   Widget  top_widget,
                   int     action_left,
                   Widget  left_widget,
                   int     action_right,
                   Widget  right_widget,
                   int     action_bottom,
                   Widget  bottom_widget )
{

  /* Variables. */
  Cardinal  n;
  Arg       args[ 10 ];


  /* Code. */

  /* Top attachment. */
  n = 0;
  XtSetArg( args[ n ], XmNtopAttachment, action_top ); n++;
  if( top_widget != NULL ) {
    XtSetArg( args[ n ], XmNtopWidget, top_widget ); n++;
  }

  /* Left attachment. */
  XtSetArg( args[ n ], XmNleftAttachment, action_left ); n++;
  if( left_widget != NULL ) {
    XtSetArg( args[ n ], XmNleftWidget, left_widget ); n++;
  }

  /* Right attachment. */
  XtSetArg( args[ n ], XmNrightAttachment, action_right ); n++;
  if( right_widget != NULL ) {
    XtSetArg( args[ n ], XmNrightWidget, right_widget ); n++;
  }

  /* Bottom attachment. */
  XtSetArg( args[ n ], XmNbottomAttachment, action_bottom ); n++;
  if( bottom_widget != NULL ) {
    XtSetArg( args[ n ], XmNbottomWidget, bottom_widget ); n++;
  }

  XtSetValues( widget, args, n );

} /* xitAttachWidget */
