/*----------------------------------------------------------------------------
--
--  Module:           XmUbNoteBook
--
--  Project:          XmUb - Ulle's Motif widgets
--  System:           
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    This is the private header file for the widget.
--
--  Filename:         XmUbNoteBkP.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-03-06
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: XmUbNoteBkP.h, Version: 1.1, Date: 95/02/18 15:10:10 */

#ifndef _XmUbNoteBkP_h
#define _XmUbNoteBkP_h

/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <X11/StringDefs.h>
#include <Xm/XmP.h>

#if XmVersion > 1001
#include "Xm/ManagerP.h"
#endif

#include "XmUbNoteBk.h"

/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

typedef int            bindingType;
typedef int            childType;
typedef unsigned char  coveredPagesPos;
typedef int            horizDir;
typedef int            scrollDirection;
typedef int            sideAttachment;
typedef int            tabPacking;
typedef int            vertDir;

/* CLASS RECORD */

typedef struct {

  XtPointer  extension;

} XmUbNoteBookClassPart;


/* Full class record declaration. */

typedef struct {

  CoreClassPart          core_class;
  CompositeClassPart     composite_class;
  ConstraintClassPart    constraint_class;
  XmManagerClassPart     manager_class;
  XmUbNoteBookClassPart  notebook_class;

} XmUbNoteBookClassRec;


/* INSTANCE RECORD */

typedef struct {

  /* RESOURCES. */
  /* Offsets and spacings. */
  Boolean          equalize_tabs_top;
  Boolean          equalize_tabs_left;
  Boolean          equalize_tabs_right;
  Boolean          equalize_tabs_bottom;
  int              tab_spacing_top;
  int              tab_spacing_left;
  int              tab_spacing_right;
  int              tab_spacing_bottom;
  int              scroll_offset_top;
  int              scroll_offset_left;
  int              scroll_offset_right;
  int              scroll_offset_bottom;

  /* Packing and sizing. */
  tabPacking       tab_packing;

  /* Tab directions. */
  vertDir          tab_dir_left;
  vertDir          tab_dir_right;
  horizDir         tab_dir_top;
  horizDir         tab_dir_bottom;

  /* Binding. */
  Pixmap           binding_pixmap_center;
  Pixmap           binding_pixmap_start;
  Pixmap           binding_pixmap_end;
  Boolean          repeat_center_binding;
  sideAttachment   binding_side;
  bindingType      binding_type;

  /* Book sides. */
  Dimension        book_side_extent;
  coveredPagesPos  book_pages_sides;

  /* Display area. */
  Widget           work_area;
  Boolean          resize_work_area;

  /* Colors. */
  Pixel            front_page_background;
  Pixel            covered_page_background;

  /* Resize behavior. */
  Boolean          resize_allowed;
  Boolean          front_page_fixed;
  Boolean          work_area_decides_size;

  /* Internal resources for redisplay. */
  Boolean          _internal_repos_kids;

  /* PRIVATE STATE. */
  Boolean          resize_called;  /* Because unclear widget set philosophy. */
  Boolean          internal_resize;  
  Boolean          nonexposed_resize;

  /* Book side positions. */
  Position         front_page_top_pos;
  Position         front_page_left_pos;
  Position         front_page_right_pos;
  Position         front_page_bottom_pos;

  /* GC's. */
  GC               line_draw_gc;
  GC               front_page_gc;
  GC               covered_page_gc;

  /* Selected tabs on each side. */
  Widget           selected_tabs[ 4 ];
  Boolean          unstacked_tabs[ 4 ];
  
} XmUbNoteBookPart;

/* Full instance record declaration. */

typedef struct _XmUbNoteBookRec {

  CorePart          core;
  CompositePart     composite;
  ConstraintPart    constraint;
  XmManagerPart     manager;
  XmUbNoteBookPart  notebook;

} XmUbNoteBookRec;



/* Constraint record for the children of this widget. */
typedef struct {

  childType        child_type;
  sideAttachment   side;
  scrollDirection  scroll_direction;

} XmUbNoteBookConstraintsPart;


typedef struct {

  XmManagerConstraintPart      manager;
  XmUbNoteBookConstraintsPart  notebook;

} XmUbNoteBookConstraintsRec, *XmUbNoteBookConstraints;

/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Conventional declaration. */
extern XmUbNoteBookClassRec xmUbNoteBookClassRec;

/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

#endif
