/*----------------------------------------------------------------------------
--
--  Module:           xtmEdAclAfs
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmEdAclAfs.
--
--  Filename:         xtmEdAclAfs.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-30
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmEdAclAfs.h, Version: 1.1, Date: 95/02/18 15:58:54 */


/* Include this file only once. */
#ifndef define_xtmEditAclAfs_h
#  define define_xtmEditAclAfs_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xitInfo.h"
#include "xtmGlobal.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_AA_REASON_APPLY,
  XTM_AA_REASON_CHANGED,
  XTM_AA_REASON_DESTROY,
  XTM_AA_REASON_OK
} XTM_AA_REASON;

/* Handle to use when comminucating with the window. */
typedef  void  *XTM_AA_HANDLE;

/* Callback. */
typedef void ( *XTM_AA_ACTION_CB ) (XTM_AA_REASON, void *);


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xtmAaDestroy( XTM_AA_HANDLE  acl_handle );

void
  xtmAaEditAcl( XTM_AA_HANDLE  acl_handle,
                char           *cal_name,
                char           *cal_location );

XTM_AA_HANDLE
  xtmAaInitialize( XTM_GL_CUSTOM_DATA_REF  custom_data_ref,
                   XIT_IN_HANDLE           info_handle,
                   Widget                  parent,
                   char                    *system_admin_acl,
                   XTM_AA_ACTION_CB        actionCB,
                   void                    *user_data );

#endif
