/*----------------------------------------------------------------------------
--
--  Module:           System
--
--  Project:          Tools
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface for module System.
--
--  Filename:         System.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-01-30
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: System.h, Version: 1.2, Date: 95/06/25 20:14:38 */


/* Include only once. */
#ifndef System_h
#  define System_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <limits.h>
#include <stddef.h>
#include <sys/types.h>

#include "Standard.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Version. */
#define VERSION_ID     "V3.0.3"

/* Version without V and any dot (.). */
#define SYS_VERSION_ID     "303"


/* Memory handling functions. */
#define SysNew( type ) \
  ( (type *) SysMalloc( (unsigned) sizeof( type ) ) )

#define SysNewString( string ) \
  ( strcpy( SysMalloc( (unsigned) strlen( string ) + 1 ), string ) )

/* Number of elements in an array. */
#define SysNumber( array ) \
  ( (unsigned) ( sizeof( array ) / sizeof( array[ 0 ] ) ) )


/* Memory functions with debug information. */
#define SysCalloc( elements, element_size ) \
  SysBaseCalloc( (size_t)(elements), (size_t)(element_size), "", __LINE__ )

#define SysFree( pointer ) \
  SysBaseFree( (void *)(pointer), "", __LINE__ )

#define SysMalloc( element_size ) \
  SysBaseMalloc( (size_t)(element_size), "", __LINE__ )

#define SysRealloc( pointer, new_size ) \
  SysBaseRealloc( (void *)(pointer), (size_t)(new_size), "", __LINE__ )


/* System parameters. */
#ifndef PATH_MAX
#  ifdef _POSIX_PATH_MAX
#    define PATH_MAX _POSIX_PATH_MAX
#  else
#    define PATH_MAX 1024
#  endif
#endif


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  *SysBaseCalloc( size_t  elements,
                  size_t  element_size,
                  char    *file_name,
                  int     line_no );

void
  SysBaseFree( void  *pointer,
               char  *file_name,
               int   line_no );

void
  *SysBaseMalloc( size_t  element_size,
                  char    *file_name,
                  int     line_no );

extern void
  *SysBaseRealloc( void    *pointer,
                   size_t  new_size,
                   char    *file_name,
                   int     line_no );

void
  SysDebugOn( Boolean  state );

char
  *SysExpandFilename( char  *filename );

void
  SysInitializeEnvironment();

void
  SysPrintErrMsg( Boolean  state );

#endif
