/*----------------------------------------------------------------------------
--
--  Module:           LstLinked
--
--  Project:          Tools - General C objects.
--  System:           Lst - Linked lists.
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module LstLinked.
--
--  Filename:         LstLinked.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1990-12-01
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: LstLinked.h, Version: 1.1, Date: 95/02/18 14:32:28 */


/* Only include this module once. */
#ifndef define_LstLinked_h
#  define define_LstLinked_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

typedef enum { LST_OK, LST_ERROR, LST_STUCK, LST_NOT_FOUND }  LST_STATUS;

typedef enum { LST_FORWARD, LST_BACKWARD } LST_DIRECTION;

typedef enum { 
  LST_EQUAL, LST_NOT_EQUAL, LST_GREATER_THAN, LST_LESS_THAN 
} LST_COMPARE;


typedef LST_COMPARE ( *EQUALS_FUNC_TYPE ) (void *, void *);

typedef void ( *CLEAR_DATA_FUNC_TYPE ) (void *);

typedef struct LST_RECORD_TYPE_ {
  void                     *record;
  struct LST_RECORD_TYPE_  *next;
  struct LST_RECORD_TYPE_  *previous;
} LST_RECORD_TYPE;

typedef struct {
  int               record_size;
  int               elements;
  LST_RECORD_TYPE   *head;
  LST_RECORD_TYPE   *tail;
  LST_RECORD_TYPE   *current;
  EQUALS_FUNC_TYPE  equals_func;
} LST_DESC_RECORD, *LST_DESC_TYPE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  LstLinkClear( LST_DESC_TYPE list_desc );

void
  LstLinkClearDataAndList( LST_DESC_TYPE         list_desc,
                           CLEAR_DATA_FUNC_TYPE  clear_func );

LST_STATUS  
  LstLinkCurrentFirst( LST_DESC_TYPE list_desc );

LST_STATUS
  LstLinkCurrentLast( LST_DESC_TYPE list_desc );

LST_STATUS
  LstLinkCurrentNext( LST_DESC_TYPE list_desc );

LST_STATUS
  LstLinkCurrentPosition( LST_DESC_TYPE list_desc,
                          int           position );

LST_STATUS
  LstLinkCurrentPrevious( LST_DESC_TYPE list_desc );

LST_STATUS
  LstLinkDeleteCurrent( LST_DESC_TYPE list_desc );

LST_STATUS
  LstLinkDeleteFirst( LST_DESC_TYPE list_desc );

LST_STATUS
  LstLinkDeleteLast( LST_DESC_TYPE list_desc );

int
  LstLinkElements( LST_DESC_TYPE list_desc );

LST_STATUS
  LstLinkGetCurrent( LST_DESC_TYPE list_desc,
                     void          *record );

LST_STATUS
  LstLinkGetFirst( LST_DESC_TYPE list_desc,
                   void          *record );

LST_STATUS
  LstLinkGetLast( LST_DESC_TYPE list_desc,
                  void          *record );

void 
  *LstLinkGetCurrentRef( LST_DESC_TYPE list_desc );

LST_STATUS
  LstLinkInsertCurrent( LST_DESC_TYPE list_desc,
                        void          *record );

LST_STATUS
  LstLinkInsertFirst( LST_DESC_TYPE list_desc,
                      void          *record );

LST_STATUS
  LstLinkInsertLast( LST_DESC_TYPE list_desc,
                     void          *record );

LST_DESC_TYPE
  LstLinkNew( int               record_size,
              EQUALS_FUNC_TYPE  equals_func );

LST_STATUS
  LstLinkSearchCurrent( LST_DESC_TYPE     list_desc,
                        void              *element,
                        LST_DIRECTION     direction,
                        EQUALS_FUNC_TYPE  equals_func );

LST_STATUS
  LstLinkSearchFirst( LST_DESC_TYPE     list_desc,
                      void              *element,
                      EQUALS_FUNC_TYPE  equals_func );

LST_STATUS
  LstLinkSearchLast( LST_DESC_TYPE     list_desc,
                     void              *element,
                     EQUALS_FUNC_TYPE  equals_func );

LST_STATUS
  LstLinkSetCurrent( LST_DESC_TYPE list_desc,
                     void          *record );

LST_STATUS
  LstLinkSetFirst( LST_DESC_TYPE list_desc,
                   void          *record );

LST_STATUS
  LstLinkSetLast( LST_DESC_TYPE list_desc,
                  void          *record );

#endif
