/*----------------------------------------------------------------------------
--
--  Module:           xtmOpenView
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmOpenView.
--
--  Filename:         xtmOpenView.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-06-15
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmOpenView.h, Version: 1.1, Date: 95/02/18 15:52:37 */


/* Include this file only once. */
#ifndef define_xtmOpenView_h
#  define define_xtmOpenView_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"
#include "xtmCalDb.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_OV_REASON_DESTROY,
  XTM_OV_REASON_APPLY,
  XTM_OV_REASON_OK
} XTM_OV_REASON;

/* Handle to use when comminucating with the summary window. */
typedef  void  *XTM_OV_HANDLE;

/* Callback when Apply/OK is selected. */
typedef void ( *XTM_OV_ACTION_CB ) (XTM_OV_REASON, XTM_CD_CAL_INFO *, void *);


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xtmOvDestroy( XTM_OV_HANDLE  open_handle );

XTM_OV_HANDLE
  xtmOvInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                parent,
                   Boolean               appl_modal,
                   XTM_OV_ACTION_CB      actionCB,
                   void                  *user_data );

void 
  xtmOvOpenView( XTM_OV_HANDLE  open_handle );

#endif
