/*----------------------------------------------------------------------------
--
--  Module:           xtmFields
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for the xtmFields module.
--
--  Filename:         xtmFields.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-04-01
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmFields.h, Version: 1.1, Date: 95/02/18 15:52:21 */


/* Only include this file once. */
#ifndef define_xtmFields_h
#  define define_xtmFields_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "LstLinked.h"
#include "TimDate.h"

#include "xtmGlobal.h"
#include "xtmCalDb.h"
#include "xtmTags.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Callback from range field. */
typedef void ( *XTM_FL_RANGE_ACTION_CB ) ( char *, void * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

Widget
  xtmFlCreateColorField( Widget          parent,
                         char            *name,
                         int             width,
                         char            *colors,
                         XtCallbackProc  changedCB,
                         void            *cb_data );

Widget
  xtmFlCreateDateField( Widget   parent,
                        char     *name );

Widget
  xtmFlCreateDateTimeField( Widget   parent,
                            char     *name );

Widget
  xtmFlCreateDbField( Widget          parent,
                      char            *name,
                      XTM_CD_HANDLE   cal_db_handle,
                      Boolean         only_can_write,
                      XtCallbackProc  changedCB,
                      void            *cb_data );

Widget
  xtmFlCreateRangeField( Widget  parent,
                         char    *name );

Widget
  xtmFlCreateSelField( Widget          parent,
                       char            *name,
                       int             width,
                       char            *selections,
                       char            sel_separator,
                       Boolean         sort,
                       XtCallbackProc  changedCB,
                       void            *cb_data );

Widget
  xtmFlCreateTagsField( Widget          parent,
                        char            *name,
                        int             width,
                        char            *tags,
                        XTM_TG_HANDLE   tag_handle,
                        XtCallbackProc  changedCB,
                        void            *cb_data );

Widget
  xtmFlCreateTimeField( Widget  parent,
                        char    *name );

#endif
