/*----------------------------------------------------------------------------
--
--  Module:           xtmEntryClip
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    A clipboard for entries. Entries can be saved and retrieved in the
--    clipboard.
--
--  Filename:         xtmEntryClip.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-08-24
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xtmEntryClip.c, Version: 1.1, Date: 95/02/18 15:52:20";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include <X11/Intrinsic.h>

#include "System.h"

#include "xtmGlobal.h"
#include "xtmDbTools.h"
#include "xtmEntryClip.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Name of module. */
static char  *module_name = "xtmEntryClip";

/* Any entries in the clipboard? */
static Boolean  clipboard_empty = True;

/* Entry in clipboard. */
static XTM_DB_ALL_ENTRY_DEF  clipboard_entry;

/* Text for entry in clipboard. */
static char  *clipboard_text = NULL;


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Boolean
  xtmEcIsClipboardEmpty()
{

  /* Code. */

  return( clipboard_empty );

} /* xtmEcIsClipboardEmpty */


/*----------------------------------------------------------------------*/

Boolean
  xtmEcRetrieveEntry( XTM_DB_ALL_ENTRY_DEF  *entry,
                      char                  **entry_text )
{

  /* Code. */

  if( clipboard_empty )
    return( False );

  /* Retrieve the entry. */
  memcpy( entry, &clipboard_entry, sizeof( XTM_DB_ALL_ENTRY_DEF ) );

  /* Retrieve any text? */
  if( clipboard_text != NULL )
    *entry_text = SysNewString( clipboard_text );
  else
    *entry_text = NULL;

  return( True );

} /* xtmEcRetrieveEntry */


/*----------------------------------------------------------------------*/

void
  xtmEcSaveEntry( XTM_DB_ALL_ENTRY_DEF  *entry,
                  char                  *entry_text )
{

  /* Code. */

  /* Save the entry. */
  memcpy( &clipboard_entry, entry, sizeof( XTM_DB_ALL_ENTRY_DEF ) );

  /* Release any old text. */
  if( clipboard_text != NULL ) {
    SysFree( clipboard_text );

    clipboard_text = NULL;
  }

  /* Save any text? */
  if( entry_text != NULL )
    clipboard_text = SysNewString( entry_text );

  clipboard_empty = False;

  return;

} /* xtmEcSaveEntry */

