/*----------------------------------------------------------------------------
--
--  Module:           xtmEditAlarm
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xtmEditAlarm.c.
--
--  Filename:         xtmEditAlarm.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-10
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmEditAlarm.h, Version: 1.1, Date: 95/02/18 15:52:15 */


/* Only include this module once. */
#ifndef define_xtmEditAlarm_h
#  define define_xtmEditAlarm_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

#define XTM_EA_MAX_ALARMS    5
#define XTM_EA_MAX_TUNES     5


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Values passed to the alarm window. */
typedef struct {
  Boolean  alarm_valid[ XTM_EA_MAX_ALARMS ];
  int      alarm_melody;
  int      alarm_offset[ XTM_EA_MAX_ALARMS ];
  UINT32   alarm_action;
  UINT32   what_action;
} XTM_EA_SET_ALARM_DATA;

/* Result values passed from the alarm window. */
typedef struct {
  Boolean  alarm_valid[ XTM_EA_MAX_ALARMS ];
  int      alarm_melody;
  int      alarm_offset[ XTM_EA_MAX_ALARMS ];
  UINT32   alarm_action;
  UINT32   what_action;
} XTM_EA_GET_ALARM_DATA;


/* Reasons when the action routine is called. */
typedef enum {
  XTM_EA_REASON_CANCEL,
  XTM_EA_REASON_DESTROY,
  XTM_EA_REASON_OK
} XTM_EA_REASON;

/* Callback when the alarm window is destroyed. */
typedef void ( *XTM_EA_ACTION_CB ) ( XTM_EA_REASON, 
                                     void *, XTM_EA_GET_ALARM_DATA * );

/* Handle to use when comminucating with the alarm window. */
typedef  void  *XTM_EA_HANDLE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmEaDestroy( XTM_EA_HANDLE  alarm_handle );

void
  xtmEaEditAlarms( XTM_EA_HANDLE          alarm_handle,
                   XTM_EA_SET_ALARM_DATA  *values_ref );

XTM_EA_HANDLE
  xtmEaInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                parent,
                   XTM_EA_ACTION_CB      actionCB,
                   void                  *user_data );

#endif

