/*----------------------------------------------------------------------------
--
--  Module:           xtmDbInclude
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmDbInclude.
--
--  Filename:         xtmDbInclude.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-01-07
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmDbInclude.h, Version: 1.1, Date: 95/02/18 15:52:09 */


/* Include this file only once. */
#ifndef define_xtmDbInclude_h
#  define define_xtmDbInclude_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"
#include "xtmCalDb.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_DI_REASON_OK,
  XTM_DI_REASON_APPLY,
  XTM_DI_REASON_CANCEL,
  XTM_DI_REASON_DESTROY
} XTM_DI_REASON;

/* Handle to use when comminucating with the include window. */
typedef  void  *XTM_DI_HANDLE;

/* Callback when Apply/OK is selected. */
typedef void ( *XTM_DI_ACTION_CB ) (XTM_DI_REASON, 
                                    XTM_CD_INCL_CALS_REF, void *);


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xtmDiDestroy( XTM_DI_HANDLE  include_handle );

void
  xtmDiDisplayIncludeWindow( XTM_DI_HANDLE  include_handle,
                             char           *cal_name );

XTM_DI_HANDLE
  xtmDiInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                parent,
                   Boolean               app_modal,
                   XTM_DI_ACTION_CB      actionCB,
                   void                  *user_data );

#endif
