/*----------------------------------------------------------------------------
--
--  Module:           xtmDateSel
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmDateSel.
--
--  Filename:         xtmDateSel.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-06-10
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmDateSel.h, Version: 1.1, Date: 95/02/18 15:52:07 */


/* Include this module only once. */
#ifndef define_xtmDateSelect_h
#  define define_xtmDateSelect_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "TimDate.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_DS_REASON_OK,
  XTM_DS_REASON_TODAY
} XTM_DS_REASON;

/* Callback when the window is destroyed. */
typedef void ( *XTM_DS_ACTION_CB ) ( XTM_DS_REASON, int, int, int, void * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void 
  xtmDsCreateSelectYearMonth( Widget            parent,
                              TIM_TIME_REF      current_date,
                              XTM_DS_ACTION_CB  actionCB,
                              void              *user_data );

#endif
