/*----------------------------------------------------------------------------
--
--  Module:           xtmCustImp
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmCustImp.
--
--  Filename:         xtmCustImp.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-11-10
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmCustImp.h, Version: 1.1, Date: 95/02/18 15:52:05 */


/* Include this file only once. */
#ifndef define_xtmCustImport_h
#  define define_xtmCustImport_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmCalDb.h"
#include "xtmCustom.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_CP_REASON_IMPORT,
  XTM_CP_REASON_DESTROY
} XTM_CP_REASON;

/* Handle to use when comminucating with the window. */
typedef  void  *XTM_CP_HANDLE;

/* Callback from the window. */
typedef void ( *XTM_CP_ACTION_CB ) ( XTM_CP_REASON, char *, void * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xtmCpDestroy( XTM_CP_HANDLE  imp_handle );

void 
  xtmCpImportCalendar( XTM_CP_HANDLE  imp_handle,
                       XTM_CD_HANDLE  cal_db_handle );

XTM_CP_HANDLE
  xtmCpInitialize( XTM_GL_CUSTOM_DATA_REF  custom_data_ref,
                   Widget                  parent,
                   XTM_CP_ACTION_CB        actionCB,
                   void                    *user_data );


#endif
