/*----------------------------------------------------------------------------
--
--  Module:           xtmCustGroup
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmCustGroup.
--
--  Filename:         xtmCustGroup.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-07-10
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmCustGroup.h, Version: 1.1, Date: 95/02/18 15:52:04 */


/* Include this module only once. */
#ifndef define_xtmCustGroups_h
#  define define_xtmCustGroups_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "LstLinked.h"

#include "xtmGlobal.h"
#include "xtmGroupDb.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_CG_REASON_OK,
  XTM_CG_REASON_DESTROY,
  XTM_CG_REASON_POPDOWN
} XTM_CG_REASON;

/* Handle to use when comminucating with the groups window. */
typedef  void  *XTM_CG_HANDLE;

/* Callback from the group window. */
typedef void ( *XTM_CG_ACTION_CB ) ( XTM_CG_REASON, XTM_GD_HANDLE, void * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

XTM_CG_HANDLE
  xtmCgInitialize( XTM_CU_BASE_DATA_REF  appl_data_ref,
                   Widget                parent,
                   XTM_CG_ACTION_CB      actionCB,
                   void                  *user_data );

void 
  xtmCgCustomGroups( XTM_CG_HANDLE  group_handle );

void
  xtmCgDestroy( XTM_CG_HANDLE  group_handle );

#endif
