/*----------------------------------------------------------------------------
--
--  Module:           xtmCustBase
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmCustBase.
--
--  Filename:         xtmCustBase.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-15
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmCustBase.h, Version: 1.1, Date: 95/02/18 15:52:02 */


/* Include this file only once. */
#ifndef define_xtmCustBase_h
#  define define_xtmCustBase_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Status variable. */
typedef enum {
  XTM_CB_OK, XTM_CB_ERROR, XTM_CB_WRONG_VERSION
} XTM_CB_STATUS;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

XTM_CB_STATUS
  xtmCbGetDataFromFile( XTM_GL_CUSTOM_DATA_REF  custom_data );

XTM_CB_STATUS
  xtmCbPutDataToFile( XTM_GL_CUSTOM_DATA_REF  custom_data );

XTM_CB_STATUS
  xtmCbRereadParamFromFile( XTM_GL_CUSTOM_DATA_REF  custom_data );

int
  xtmCbWhatVersion();

#endif
