/*----------------------------------------------------------------------------
--
--  Module:           xtmCpMvEntry
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmCpMvEntry.
--
--  Filename:         xtmCpMvEntry.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-01-23
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmCpMvEntry.h, Version: 1.1, Date: 95/02/18 15:52:00 */


/* Include this module only once. */
#ifndef define_xtmCopyMoveEntry_h
#  define define_xtmCopyMoveEntry_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Do the copy/move operation. */
typedef enum { 
  XTM_CM_COPY, 
  XTM_CM_MOVE
} XTM_CM_OPERATION;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void 
  xtmCmCopyMoveEntry( XTM_GL_BASE_DATA_REF  appl_data_ref,
                      Widget                parent,
                      XTM_CM_OPERATION      operation,
                      char                  *cal_name,
                      UINT32                entry_id );

void
  xtmCmCopyMoveEntryTo( XTM_GL_BASE_DATA_REF  appl_data_ref,
                        Widget                parent,
                        XTM_CM_OPERATION      operation,
                        char                  *from_cal_name,
                        UINT32                from_entry_id,
                        char                  *to_cal_name,
                        TIM_TIME_REF          to_date,
                        TIM_TIME_REF          to_time );

#endif
