/*----------------------------------------------------------------------------
--
--  Module:           xtmAccessBase
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmAccessBase.
--
--  Filename:         xtmAccBase.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-15
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmAccBase.h, Version: 1.1, Date: 95/02/18 15:51:49 */


/* Include this file only once. */
#ifndef define_xtmAccessBase_h
#  define define_xtmAccessBase_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "Standard.h"
#include "LstLinked.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Access flags. */
#define XTM_AB_FLAG_READ           (1<<0)
#define XTM_AB_FLAG_WRITE          (1<<1)
#define XTM_AB_FLAG_PRIV           (1<<2)
#define XTM_AB_FLAG_MSG            (1<<3)

/* AFS id's can be up to this length. */
#define XTM_AB_MAX_AFS_ID_LENGTH       500


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Status variable. */
typedef enum {
  XTM_AB_OK, XTM_AB_ERROR
} XTM_AB_STATUS;

/* Access information. */
typedef struct {
  int     uid;
  int     gid;
  UINT32  flags;
} XTM_AB_ACCESS_INFO;


/* Afs acl information. */
typedef struct {
  char    id[ XTM_AB_MAX_AFS_ID_LENGTH + 1 ];
  UINT32  flags;
} XTM_AB_AFS_ACL_INFO;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

XTM_AB_STATUS
  xtmAbGetAccessInfo( char           *directory,
                      LST_DESC_TYPE  *access_info );

XTM_AB_STATUS
  xtmAbGetAfsAccessInfo( char           *directory,
                         LST_DESC_TYPE  *access_info );

XTM_AB_STATUS
  xtmAbGetUserOperations( char    *directory,
                          int     user_id,
                          int     group_id,
                          UINT32  *operations );

XTM_AB_STATUS
  xtmAbSaveAccessInfo( char           *directory,
                       LST_DESC_TYPE  access_info );

XTM_AB_STATUS
  xtmAbSaveAfsAccessInfo( char           *directory,
                          LST_DESC_TYPE  access_info );

#endif
