%---------------------------------------------------------------------------
%  Name:     XDpsList.pro
%  Project:  XDiary
%
%  Description:
%   Prolog file for PostScript output from XDiary.
%   Format is: List
%
%  Filename:         XDpsList.pro
%
%  Authors:          Roger Larsson, Ulrika Bornetun
%  Creation date:    1992-06-10
%
%
%  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
%      All rights reserved
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any purpose and without fee is hereby granted,
%  provided that the above copyright notice appear in all copies. Ulrika
%  Bornetun and Roger Larsson make no representations about the usability
%  of this software for any purpose. It is provided "as is" without express
%  or implied warranty.
%---------------------------------------------------------------------------
%
% SCCSID = @(#) Module: XDpsList.pro, Version: 1.1, Date: 95/02/18 14:15:07

#include XDpsCommon.pro

%--------------------  Font procedures  --------------------
%

/Courier               /Courier-NLS NLSvec reEncodeSmall
/Helvetica             /Helvetica-NLS NLSvec reEncodeSmall
/Helvetica-Bold        /Helvetica-Bold-NLS NLSvec reEncodeSmall
/Helvetica-Oblique     /Helvetica-Oblique-NLS NLSvec reEncodeSmall
/Helvetica-BoldOblique /Helvetica-BoldOblique-NLS NLSvec reEncodeSmall

/DayTitleFontSize 12 scaleFont mul def
/dayTitleFont {
  /Helvetica-Bold-NLS findfont DayTitleFontSize scalefont setfont
} def

/EntryTitleFontSize 10 scaleFont mul def
/entryTitleFont {
  /Helvetica-Bold-NLS findfont EntryTitleFontSize scalefont setfont
} def

/EntryTextFontSize 10 scaleFont mul def
/entryTextFont {
  /Courier-NLS findfont EntryTextFontSize scalefont setfont
} def

/entryTextBoldFont {
  /Helvetica-Bold-NLS findfont EntryTextFontSize scalefont setfont
} def

/entryTextBoldObliqueFont {
  /Helvetica-BoldOblique-NLS findfont EntryTextFontSize scalefont setfont
} def

/HeaderFontSize 12 scaleFont mul def
/headerFont {
  /Helvetica-NLS findfont HeaderFontSize scalefont setfont
} def

/HeaderDataFontSize 12 scaleFont mul def
/headerDataFont {
  /Helvetica-Bold-NLS findfont HeaderDataFontSize scalefont setfont
} def

/FooterFontSize 12 scaleFont mul def
/footerFont {
  /Helvetica-NLS findfont FooterFontSize scalefont setfont
} def


%--------------------  Static variables  --------------------
%

/PageWidth         PageWidth mm def
/PageHeight        PageHeight mm def
/LeftMargin        LeftMargin mm def
/RightMargin       RightMargin mm def
/TopMargin         TopMargin mm def
/BottomMargin      BottomMargin mm def

/DayNewPage        false def

/HeaderHeight      15 mm def
/FooterHeight       7 mm def
/HeaderTextMargin  30 mm def

/MaxLineLength 78 def

/DayTitleSpacing    DayTitleFontSize 1.2 mul def
/EntryTitleSpacing  EntryTitleFontSize 1.2 mul def
/EntryTextSpacing   EntryTextFontSize 1.2 mul def
/FooterSpacing      FooterFontSize 1.2 mul def
/HeaderSpacing      HeaderFontSize 1.2 mul def

/HalfHeight PageHeight 2 div 1.4 mul def

/BottomLimit     BottomMargin FooterHeight add 5 mm add def
/PrintAreaWidth  PageWidth LeftMargin sub RightMargin sub def
/PrintAreaHeight PageHeight TopMargin sub BottomMargin sub def

/Buffer 100 string def


%--------------------  Counters  --------------------
%

/PageCount 0 def


%--------------------  Page header  --------------------
%

/headerBackground {
  % Draw the header background.

  newpath
  1 mm setlinewidth
  0 0 moveto
  PrintAreaWidth 0 lineto
  stroke
  gsave
    0 3 mm translate
    3.1 3.1 scale
    xdiaryLogo
  grestore
} def


/headerText {
  % Write the header text.
  %   dateRange dateLabel dbNames dbLabel

  headerFont

  % Length of first string.
  dup stringwidth pop
  /Length exch def

  /Line 9 mm def
  HeaderTextMargin Line moveto
  show

  headerDataFont
  HeaderTextMargin Length add Line moveto
  show

  headerFont
  /Line 9 mm HeaderSpacing sub def
  HeaderTextMargin Line moveto
  show

  headerDataFont
  HeaderTextMargin Length add Line moveto
  show
} def


/header {
  % Write the header.

  DisplayHeader {
    headerBackground
    headerText
  } if
} def


/footerBackground {
  % Draw the footer background.

  newpath
  0 0 moveto
  PrintAreaWidth 0 lineto
  stroke
} def


/footerText {
  % Draw the footer text.
  %   footerDate

  footerFont
  /Line 0 FooterSpacing sub def
  Duplex PageCount 2 mod 0 eq and {
    PrintAreaWidth rightJustifyText
  } {
    0 Line moveto
    show
  } ifelse

  Duplex PageCount 2 mod 0 eq and {
    0 Line moveto
    PageCount Buffer cvs show
  } {
    PageCount Buffer cvs PrintAreaWidth rightJustifyText
  } ifelse
} def


/footer {
  % Display the footer.

  DisplayFooter {
    footerBackground
    footerText
  } if
} def


/basicForm {
  % Display the background page.
  %   dbLabel dbNames dateLabel dateRange footerDate

  % header
  gsave
    LeftMargin PageHeight TopMargin sub HeaderHeight sub translate
    header
  grestore

  % footer
  gsave
    LeftMargin BottomMargin FooterHeight add translate
    footer
  grestore
} def


%--------------------  XDiary logo  --------------------
%

/xdiaryLogo {
  % Size in units: 22x10

  newpath

  % The calendar sheet.
  gsave
    0   0 moveto
    10  0 lineto
    12 2 13 6 13 10 curveto
    3  10 lineto
    3 6 2 2 0 0 curveto
    gsave
      1 16 div setlinewidth
      0.4 setgray
      stroke
    grestore
    0.8 setgray
    fill
  grestore

  % Draw the X.
  gsave
    1 1 translate
    1 0 moveto
    10 6 lineto
    11 6 lineto
    2 0 lineto
    2 0 lineto
    fill
    3 6 moveto
    5 6 lineto
    9 0 lineto
    7 0 lineto
    3 6 lineto
    fill
  grestore

  % Hole 1.
  gsave
    4.5 8.5 translate
    0 0 0.5 0 360 arc
    0.2 setgray
    fill
  grestore

  % Hole 2.
  gsave
    11.5 8.5 translate
    0 0 0.5 0 360 arc
    0.2 setgray
    fill
  grestore

  % Text
  gsave
    /Helvetica-BoldOblique findfont 4 scalefont setfont
    10.5 2.5 translate
    0 0 moveto
    (Diary)
    show
  grestore
} def


%--------------------  Page procedures  --------------------
%

/newPage {
  % Finish the old page and start a new.

  eop
  bop
} def


/bop {
  % Start new page.

  gsave
  setupNewPage
} def


/eop {
  % End page.

  % Page divider?
  TwoColumn PageCount 2 mod 0 ne and {
    gsave
      PageWidth BottomMargin moveto
      PageWidth PageHeight TopMargin sub lineto
      stroke
    grestore
  } if

  grestore
  TwoColumn PageCount 2 mod 0 eq and { showpage } if
  TwoColumn not { showpage } if
} def


/lastPage {
  % Make sure the last page is displayed.

  TwoColumn PageCount 2 mod 0 ne and { showpage } if
} def


/setupNewPage {
  % Setup the new page including background.

  /PageCount PageCount 1 add def

  % Print in two columns?
  % Print in two columns?
  TwoColumn {
    0.7 0.7 scale
    90 rotate

    PageCount 2 mod 0 eq {
      LeftMargin neg BottomMargin add HalfHeight add
    } {
      LeftMargin neg BottomMargin add
    } ifelse
    PageHeight TopMargin sub LeftMargin add neg
    translate 
  } if

  FooterDate
  DateRange
  DateLabel
  DbNames
  DbLabel
  basicForm

  /Line PageHeight TopMargin sub HeaderHeight sub def
  /Line Line 8 mm sub def
} def


%--------------------  Entry procedures  --------------------
%

/importantEntry {
  % This is an important entry.

  entryTextBoldObliqueFont
} def


/importantNote {
  % This is an important note.

  entryTextBoldObliqueFont
} def


/beginEntryText {
  % Start the entry text.

  entryTextFont
} def


/daySeparator {
  % Do the separator between days.

  Line BottomLimit 40 mm add le DayNewPage or {
    newPage
  } {
    /Line Line 1 mm sub def
    newpath
    LeftMargin Line moveto
    PageWidth RightMargin sub 5 mm sub Line lineto
    3 10 div setlinewidth
    stroke
    /Line Line 5 mm sub def
  } ifelse
} def
  

/entryAppHeader {
  % Header for appointments.
  %   stopTime startTime

  /stopTime  exch def
  /startTime exch def

  Line BottomLimit 20 mm add le {
    newPage
  } {
    /Line Line 3 mm sub def
  } ifelse

  entryTitleFont
  LeftMargin 5 mm add Line moveto

  startTime makeTimeString show
  startTime stopTime ne {
    ( - ) show
    stopTime makeTimeString show
 } if

  /Line Line EntryTitleSpacing sub def
} def


/entryNoteHeader {
  % Header for notes.
  %   stopTime startTime

  /noteTitle  exch def

  Line BottomLimit 20 mm add le {
    newPage
  } {
    /Line Line 3 mm sub def
  } ifelse

  entryTitleFont
  LeftMargin 5 mm add Line moveto

  noteTitle show

  /Line Line EntryTitleSpacing sub def
} def


/entryImportantHeader {
  % Header for important entries.

  Line BottomLimit 20 mm add le {
    newPage
  } {
    /Line Line 3 mm sub def
  } ifelse

  entryTitleFont
  /SaveLine Line def
  LeftMargin 5 mm add Line moveto
  show
  /Line Line EntryTitleSpacing sub def

  % Important marker.
  gsave
    newpath
    LeftMargin SaveLine EntryTitleFontSize add moveto
    LeftMargin Line EntryTitleSpacing add lineto
    1 mm setlinewidth
    0.4 setgray
    stroke
  grestore
} def


/nel{
  entryTextLine
} def


/nnl{
  entryTextLine
} def


/entryTextLine {
  % Draw one entry text line.

  Line BottomLimit le {
    newPage
    beginEntryText
  } if

  LeftMargin 7.5 mm add Line moveto
  dup length
  /Length exch def
  Length MaxLineLength gt {
    dup 0 MaxLineLength getinterval
    show
    /Line Line EntryTextSpacing sub def
    MaxLineLength Length MaxLineLength sub getinterval
    entryTextLine
  } {
    show
    /Line Line EntryTextSpacing sub def
  } ifelse
} def


/newDay {
  % Switch to a new day.
  %   dayTitle

  /dayTitle exch def

  dayTitleFont
  LeftMargin Line moveto
  dayTitle show

  /Line Line DayTitleSpacing sub def
} def


/endEntry{
} def


/endNote{
} def


%--------------------------  Program parameters --------------------------
%

% Multiple sheets on one?
/TwoColumn false def
SheetsPerPage 2 eq {
  /TwoColumn true def
} if

% Any header and footer?
DisplayHeader not {
  /HeaderHeight 0 def
} if

% Any header and footer?
DisplayFooter not {
  /FooterHeight 0 def
} if

%%EndProlog
