/*-
 * @(#)ttfont.h -- Functions for handling FreeType library
 */

#ifdef HAVE_CONFIG_H
#  include "../config.h"
#endif

#ifndef _TTFONT_H
#define _TTFONT_H

#ifndef FREETYPE1_INCDIR
#error FREETYPE1_INCDIR must be set in config.h when configure.
#endif

#if FREETYPE1_INCDIR == 1
#  include <freetype.h>
#elif FREETYPE1_INCDIR == 2
#  include <freetype/freetype.h>
#else /* error */
#error FREETYPE1_INCDIR must be 1 or 2 in config.h when configure.
#endif

typedef struct _FreeTypeInfo {
    void		*handle;
} FreeTypeInfo;

/* Hints to open face */
typedef struct _FontFaceHints {
    char		*fontfile;
    char		*name;
    TT_UShort		 num_faces;
    int			 resolution;
    double		 point;
    int			 pixel;
    int			 ttcno;
} FontFaceHints;

/* One face in collection */
typedef struct _FontFaceInfo {
    TT_Face		 face;
    TT_Face_Properties	 properties;
    TT_Instance		 instance;
    TT_Instance_Metrics	 imetrics;
    TT_Glyph		 glyph;
    int			 advance[256];
    TT_CharMap		 charmap;
    unsigned int	(*chconv_func)(unsigned int);
    unsigned int	(*chconv_rev_func)(unsigned int);
} FontFaceInfo;

int ttfont_init();
void ttfont_deinit();

FontFaceHints *ttfont_load(char *, double);
void ttfont_unload(FontFaceHints *);

FontFaceInfo *ttfont_open_face(FontFaceHints *);
void ttfont_close_face(FontFaceInfo *);

TT_Raster_Map *ttfont_create_raster(int, int, int);
void tfont_delete_raster(TT_Raster_Map *);

TT_Raster_Map *ttfont_get_font(FontFaceInfo *, int, int);
char *ttfont_render_font(FontFaceInfo *, int *, int *, int, int);

int ttfont_is_usable_japanese(FontFaceInfo *);
int ttfont_read_fontname(FontFaceInfo *, char *, int);
int ttfont_advance(FontFaceInfo*, int);

#endif

/* ttfont.h ends here */
