/*-
 * @(#)gdkmm_pixmap.cc -- Gdk--'s Gtk_Pixmap with TrueType font
 */

#include <gdk--/colormap.h>
#include <gdk--/gc.h>
#include <gdk--/image.h>
#include<stdio.h>

#include "gdkmm_pixmap.h"
#include "gdkmm_image.h"

extern "C" {
    #include "chconv.h"
}

Gdk_Pixmap_FreeType::Gdk_Pixmap_FreeType(const Gdk_Drawable &drawable,
					 gint width, gint height, gint depth)
    : Gdk_Pixmap(drawable, width, height, depth)
{
}

Gdk_Pixmap_FreeType::~Gdk_Pixmap_FreeType()
{
}

void
Gdk_Pixmap_FreeType::draw_string(Gdk_Font_FreeType &font, Gdk_GC &gc,
				 gint x, gint y, const Gtk::string &str)
{
    /* font not extends Gdk_Font_FreeType */
    if (!font.is_usable_freetype()) {
	Gdk_Pixmap::draw_string(font, gc, x, y, str);
	return;	
    }

    /* ugh, here renders first charactor only */
    const char *c_str = str.c_str();
    unsigned int code = ((c_str[0] & 0xff) << 8) | c_str[1] & 0xff;

    /* create temporary image */
    Gdk_Image_FreeType image;

    gint width = font.char_width(code);
    gint height = font.char_measure(code);
    image.get(*this, x, y - height, width, height);

    /* get foreground color */
    GdkGCValues gcv;
    gc.get_values(gcv);
    guint32 pixel = gcv.foreground.pixel;

    /* marge text */
    image.draw_marged_text(font, 0, 0, code, pixel);
    draw_image(gc, image, 0, 0, x, y - height);
    
}

/* gdkmm_pixmap.cc ends here */
