#! /usr/bin/perl

@amix_opts=();
while( scalar(@ARGV) > 0 ) {
    if( @ARGV[0] =~ /^-c/ ) {
	push(@amix_opts,"-c");
	@ARGV[0] =~ s/^-c//;
	if( @ARGV[0] =~ /^[0-9]+$/ ) {
	    push(@amix_opts,@ARGV[0]);
	} else {
	    shift(@ARGV);
	    push(@amix_opts,@ARGV[0]);
	}
    } elsif ( @ARGV[0] =~ /^-d/ ) {
	push(@amix_opts,"-d");
	@ARGV[0] =~ s/^-d//;
	if( @ARGV[0] =~ /^[0-9]+$/ ) {
	    push(@amix_opts,@ARGV[0]);
	} else {
	    shift(@ARGV);
	    push(@amix_opts,@ARGV[0]);
	}
    }
    shift(@ARGV);
}

$amix_opt=join(" ",@amix_opts);
open(AMIX,"amixer ${amix_opt} elements|");
@vols=();
while(<AMIX>) {
    if( /^Element/ && /Volume1/ ) {
	s/\n//;
	push(@vols,$_);
    }
}
close(AMIX);

if( scalar(@vols) == 0 ) {
    printf("No amixer output.\n");
    exit(0);
}

$def_vol=-1;
$def_vol=getvol("PCM");
if( $def_vol < 0 ) {$def_vol=0;}

@amixs=();
&select_vol("Master","Master Volume");
&select_vol("CD","CD Volume");
&select_vol("Synth","MIDI Volume");
&select_vol("PCM","PCM Volume");

open(FP,">audioMix_alsa.h");

print FP "\na_mix_elements mixer_elements[4]=\{\n";
foreach $x (@amixs) {
    $x =~ /'([^']+)'/;
    $eid_name=$1;
    @xx=split(",",$x);
    print FP "\t\{\"${eid_name}\",@xx[1]\},\n";
}
print FP "\};\n";
close(FP);

sub select_vol{
    local($v_name)=shift;
    local($v_lname)=shift;
    local($x);
    print "\n\n";
    &pr_vols;
    $vol_def=&getvol($v_name);
    print "Which is '${v_lname}'.(default ${vol_def})\n? ";
    $x=<>;
    getvoln($x);
    printf "'${v_lname}' is %s .\n",@amixs[scalar(@amixs)-1];
}

sub getvol{
    local($vol)=shift;
    local($x,$a,$b);
    $x=$def_vol;
    $b=0;
    foreach $a (@vols) {
	if( $a =~ /$vol/i ) {$x=$b;}
	$b++;
    }
    return $x;
}

sub pr_vols{
    local($i);
    for( $i = 0 ; $i < scalar(@vols) ; $i++ ) {
	printf "%2d\. %s\n",$i,@vols[$i];
    }
}

sub getvoln{
    local($x)=shift;
    local($y);
    $x =~ s/\n//;
    if ( $x =~ /^[0-9]+$/ && $x >= 0 && $x < scalar(@vols) ) {
	push(@amixs,@vols[$x]);
    } else {
	push(@amixs,@vols[$vol_def]);
    }
}
	     
