// -*- c++ -*-

/*
 *  Author: Arvin Schnell
 */


#ifndef pcm_wav_h
#define pcm_wav_h


#include "pcm.h"


class PCMWAV : public PCM
{

public:

    PCMWAV (const char* name, pcm_type_t type, pcm_mode_t mode,
	    pcm_format_t format, int channels, int rate, int buffer_size);
    ~PCMWAV ();

    void info () const;
    size_t size ();
    off_t seek (off_t offset, int whence);
    size_t read (void* buffer, size_t frames);
    size_t write (void* buffer, size_t frames);

private:

    int fd;

    struct WAVHeader
    {
	uint32_t chunk_id;
	uint32_t chunk_size;
	uint32_t format;
	uint32_t sub_chunk_id;
	uint32_t sub_chunk_size;
	uint16_t audio_format;
	uint16_t num_channels;
	uint32_t sample_rate;
	uint32_t byte_rate;
	uint16_t block_align;
	uint16_t bit_per_sample;
	uint32_t data_chunk_id;
	uint32_t data_chunk_size;
    };

    bool check_header (const WAVHeader&, size_t) const;
    void fill_header (WAVHeader*, size_t) const;

};


#endif
