/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Path;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Exec;

public class Java
extends Exec {
    private String classname = null;
    private String args = null;
    private String jvmargs = null;
    private Path classpath = null;
    private boolean fork = false;

    protected String[] array(Vector v) {
        String[] s = new String[v.size()];
        Enumeration e = v.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            s[i] = (String)e.nextElement();
            ++i;
        }
        return s;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path();
        }
        return this.classpath;
    }

    public void execute() throws BuildException {
        this.executeJava();
    }

    public int executeJava() throws BuildException {
        this.log("Calling " + this.classname, 3);
        if (this.classname == null) {
            throw new BuildException("Classname must not be null.");
        }
        if (this.fork) {
            StringBuffer b = new StringBuffer();
            b.append("java ");
            if (this.classpath != null) {
                b.append("-classpath ");
                b.append(this.classpath.toString());
                b.append(" ");
            }
            if (this.jvmargs != null) {
                b.append(this.jvmargs);
                b.append(" ");
            }
            b.append(this.classname);
            if (this.args != null) {
                b.append(" ");
                b.append(this.args);
            }
            return this.run(b.toString());
        }
        Vector argList = this.tokenize(this.args);
        if (this.jvmargs != null) {
            this.log("JVM args and classpath ignored when same JVM is used.", 3);
        }
        this.log("Java args: " + argList.toString(), 3);
        this.run(this.classname, argList);
        return 0;
    }

    protected void run(String classname, Vector args) throws BuildException {
        try {
            Class[] param = new Class[]{Class.forName("[Ljava.lang.String;")};
            Class<?> c = Class.forName(classname);
            Method main = c.getMethod("main", param);
            Object[] a = new Object[]{this.array(args)};
            main.invoke(null, a);
        }
        catch (NullPointerException nullPointerException) {
            throw new BuildException("Could not find main() method in " + classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException("Could not find " + classname + ". Make sure you have it in your classpath");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (!(t instanceof SecurityException)) {
                throw new BuildException(t.toString());
            }
        }
        catch (Exception e) {
            throw new BuildException(e.toString());
        }
    }

    public void setArgs(String s) {
        this.args = s;
    }

    public void setClass(String s) {
        this.log("The class attribute is deprecated. Please use the classname attribute.", 1);
        this.classname = s;
    }

    public void setClassname(String s) {
        this.classname = s;
    }

    public void setClasspath(Path s) {
        if (this.classpath == null) {
            this.classpath = s;
        } else {
            this.classpath.append(s);
        }
    }

    public void setFork(String s) {
        this.fork = Project.toBoolean(s);
    }

    public void setJvmargs(String s) {
        this.jvmargs = s;
    }

    protected Vector tokenize(String args) {
        Vector<String> v = new Vector<String>();
        if (args == null) {
            return v;
        }
        StringTokenizer t = new StringTokenizer(args, " ");
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        return v;
    }
}

