/* wmphoto.c
 * Copyright(c) 1999, by Aldrin Martoq A. (amartoq@cec.uchile.cl)
 *
 * This program is distributed under the GPL License, see de "COPYING" file
 * in the main distribution.
 *
 * This code is based and uses partly of the wmgeneral code; found in the
 * wmmon.app by Martijn Pieterse (pieterse@xs4all.nl) and Antoine Nulle
 * (warp@xs4all.nl); which is based based in wmppp/wmifs; which is based in
 * pppstats and asclock; which... Everything is GPL, hopefully.
 *
 * And this story is too large to put it here. :-)
 */

#include "wmphoto.h"

#include "marco0.xpm"
#include "marco0-mask.xbm"



#define WMPHOTO_VERSION "0.3a"



/* Global variables */
XImage *pixmap_copy;
unsigned long myfore1;
unsigned long myfore2;

char command1[1024];
char command2[1024];
char current[1024];

char home[1024];


int main(int argc, char **argv)
  {
	init_stuff(argc, argv);
	while(main_loop())
	  ;

	return 0;
  }



void init_stuff(int argc, char **argv)
  {
	/* get the user's home */
	sprintf(home,"%s/.wmphoto",getenv("HOME"));
	
	if (argc == 2)
	  {	show_usage();  }

	if (argc >= 3)
	  {	if (strcmp(argv[1], "add") == 0)
		  {	add_photo(argv[2]);  }
		show_usage();
	  }

	openXwindow(argc, argv, marco0_xpm, marco0_mask_bits,
		marco0_mask_width, marco0_mask_height);

	/* We get this to put the marco after */
	pixmap_copy = XGetImage(display, wmgen.pixmap, 0, 0, 128, 64, ~0,
		ZPixmap);
	myfore1 = XGetPixel(pixmap_copy, 127, 0);
	myfore2 = XGetPixel(pixmap_copy, 126, 0);

	//poner_marco();
	default_image();

	current[0] = 0;
	get_next_photo(current);
  }



int main_loop()
  {	static XEvent	Event;

	waitpid(0, NULL, WNOHANG);

	while (XPending(display))
	  {	XNextEvent(display, &Event);
		switch (Event.type)
		  {	case Expose:
				RedrawWindowXY(0, 0);
				break;

			case DestroyNotify:
				XCloseDisplay(display);
				return 0;
				break;

			case ButtonRelease:
				switch(Event.xbutton.button)
				  {	case 1:
						myexecCommand(command1);
						break;

					case 2:
						myexecCommand(command2);
						break;

					case 3:
						get_next_photo(current);
						break;

				  }
		  }
	  }
	/* this mean 1/4 second */
	usleep(250000L);

	return 1;
  }



void poner_marco()
  {	int i, j;
	unsigned long c;

	for (i=0; i<64; i++)
	  {	for (j = 0; j<64; j++)
		  {	c = XGetPixel(pixmap_copy, i+64, j);
			if (c == myfore1 || c == myfore2)
			  {	c = XGetPixel(pixmap_copy, i+64, j);
				XSetForeground(display, NormalGC, c);
				XDrawPoint(display, wmgen.pixmap, NormalGC, i, j);
			  }
		  }
	  }
  }



void default_image()
  {
	copyXPMArea(64, 0, 64, 64, 0, 0);
	RedrawWindowXY(0,0);
  }



void get_next_photo(char *current)
  {
	struct dirent **namelist;
	int n, i, mark;
	DIR *mydir;

	command1[0] = 0;
	command2[0] = 0;

	mydir = opendir(home);
	if (mydir == NULL)
	  {	if (errno != ENOENT)
		  {	perror("wmphoto (opendir)");  }
		default_image();
		return;
	  }
	closedir(mydir);

	n = scandir(home, &namelist, myselect, alphasort);
	if (n < 0)
	  {	perror("wmphoto (scandir)");
		default_image();
		return;
	  }

	if (n == 0)
	  {	default_image();
		return;
	  }

	if (current == NULL)
	  {	load_photo(namelist[0]->d_name);  }
	else
	  {	mark = n ;
		for (i=0; i<n; i++)
		  {	if (strcmp(namelist[i]->d_name, current) == 0)
			  {	mark = i + 1;  }
		  }

		mark = (mark == n ? 0 : mark);
		load_photo(namelist[mark]->d_name);
	  }
	while (n--)
	  {	free(namelist[n]);  }
  }



int myselect(const struct dirent *d)
  {	char *name = d->d_name;
	static int lenght;
	static char *defExt = ".xpm.gz";
	static int mylenght;

	lenght = strlen(name);
	mylenght = strlen(defExt);

	if (lenght < (mylenght + 1) || name[0] == '.' || 
		strcmp(&(name[lenght - mylenght]), defExt) != 0 )
	  {	return 0;  }

	return 1;
  }



void load_photo(char *name)
  {	Pixmap mypixmap;
	int status;
	static int lenght;
	static char *defExt = ".xpm.gz";
	static int mylenght;
	FILE *myfile;
	XpmAttributes xpmAttributes;

	mylenght = strlen(defExt);

	sprintf(current, "%s/%s", home, name);

	lenght = strlen(current);
	current[lenght - mylenght] = 0;

	myfile = fopen(current, "r");
	if (myfile != NULL)
	  {	if (fgets(command1, 1024, myfile) != NULL)
		  {	int l = strlen(command1);
			if (command1[l-1] == '\n')
			  {	command1[l-1] = 0;  }

			if (fgets(command2, 1024, myfile) != NULL)
			  {	l = strlen(command2);

				if (command2[l-1] == '\n')
				  {	command2[l-1] = 0;  }
			  }
		  }
		fclose(myfile);
	  }
	
	current[lenght - mylenght] = '.';

	xpmAttributes.valuemask = XpmCloseness;
	xpmAttributes.closeness = 65536;

	status = XpmReadFileToPixmap(display, wmgen.pixmap, current, &mypixmap,
		0, &xpmAttributes);
	strcpy(current, name);
	if (status != XpmSuccess)
	  {	fprintf(stderr, "wmphoto (XpmError): %s\n",
			XpmGetErrorString(status));
		default_image();
		return;
	  }
	XCopyArea(display, mypixmap, wmgen.pixmap, NormalGC, 0, 0, 48, 52, 8,
		6);

	XFreePixmap(display, mypixmap);
	XpmFreeAttributes(&xpmAttributes);

	poner_marco();
	RedrawWindowXY(0, 0);
  }



void myexecCommand(char *command)
  {
	if (command[0] != 0)
	  {	execCommand(command);  }
  }



void add_photo(char *filename)
  {	char profile[1024];
	DIR *mydir;
	int l;
	FILE *myfile;

	mydir = opendir(home);
	if (mydir == NULL)
	  {	if (errno != ENOENT)
		  {	perror("wmphoto (opendir)");  }

		printf("Creating %s.. ", home);
		if (mkdir(home, 0755) < 0)
		  {	fprintf(stderr, "can't create directory!\n");
			perror("wmphoto (mkdir)");
			exit(1);
		  }
		printf("good.\n\n");
	  }
	closedir(mydir);

	

	printf("Wmphoto will ask you a couple of questions now...\n");
	printf("you *need* ImageMagick's `convert` program to do this!\n\n");
	printf("Enter a name for this profile: ");
	fgets(profile, 1024, stdin);
	l = strlen(profile);
	profile[l-1] = 0;

	printf("Command to run for button1? (ex: xterm -e pine amartoq@cec.uchile.cl)\n");
	fgets(command1, 1024, stdin);

	printf("Command to run for button2? (ex: xterm -e talk amartoq@cec.uchile.cl)\n");
	fgets(command2, 1024, stdin);

	sprintf(current, "%s/%s", home, profile);
	printf("Creating %s... ", current);

	myfile = fopen(current, "w");
	if (myfile == NULL)
	  {	fprintf(stderr, "can't write file!\n");
		perror("fopen");
		exit(1);
	  }
	fprintf(myfile, "%s", command1);
	fprintf(myfile, "%s", command2);
	fclose(myfile);

	printf("good.\nExecuting convert, this may take a while...\n");
	sprintf(current, "convert -colors 255 -dither -geometry 48x52! %s xpm:%s/%s.xpm.gz", filename, home, profile);
	printf("%s ", current);
	fflush(stdout);

	system(current);

	printf("done.\n\nIf you are already running wmphoto, just press the 3rd\nbutton over it until appear your new photo.\nTo add a new photo, just run wmphoto this same way.\n\n");
	exit(0);
  }



void show_usage()
  {
	printf("[wmphoto %s] Copyright(C) 1999, by Aldrin Martoq A. (amartoq@cec.uchile.cl)\n", WMPHOTO_VERSION);

	printf("ussage:\nwmphoto\n\t Starts the wmphoto as dock app.\n\nwmphoto add <an_image_file>\n\t Add the photo <an_image_file> to your ~/.wmphoto directory interactivaly\n\t(Imagemagick's `convert` program needed).\n\n");

	exit(0);
  }
