/*
 * Copyright (c) 2002 pancake <pancake@phreaker.net>
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is included in WiStumbler2 package.
 *
 * $Id: stumbler.c,v 1.5 2003/11/14 15:54:29 pancake Exp $
 */


#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#ifdef SPEAKER_PRESENT
#ifdef __FreeBSD__
#include <machine/speaker.h>
#else
#include <machine/spkr.h>
#endif
#endif

#include "main.h"

#define SPKR_DEV "/dev/speaker"
#define SPKR_SPD "L08"

/* tones:
 *   echo "L10<<CDEFGAB>CDEFGAB"
 */
char *spkr_spd=SPKR_SPD;
char *spkr_tone="CDEFGABC";

void swap_beep(void)
#if 0
	gpointer callback_data, 
	guint callback_action,
	GtkWidget *checkitem)
#endif
{
	Cfg.beep_enable^=1;
}

void do_beep(pc)
	int pc; /* percent tone */
{
	int tone,midt;
	FILE *fd=NULL;
	char buf[30];
#ifdef SPEAKER_PRESENT
#if USE_GTK
	/* TODO Also update the global signalmeter */
	if (!NO_X)
	{
		/* fraction generator */
		gdouble pb_fraction;
		pb_fraction=(double)pc;
		pb_fraction/=100;
		if (pb_fraction>1)	pb_fraction=1;

		/* move progressbars! */
		gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(wifi_pb),pb_fraction);
		gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(popup_pb),pb_fraction);
	}
#endif
	if (! Cfg.beep_enable)
		return;

	fd=fopen(SPKR_DEV,"w");
	if (!fd) {
		perror("Cannot open speaker device");
		Cfg.beep_enable=false;
		return;
	}
	/* clean save parameters */
	if (pc>100) pc=100;
	if (pc<0)   pc=1;

	/* Speed */
	fwrite(spkr_spd,strlen(spkr_spd),1,fd);

	/* Tone */
	tone=5-(int)(pc/20); /* bigtone */
	midt=(int)(pc/14);   /* midtone */
	memset(buf,0,20);    /* eof */
	memset(buf,'<',tone);
	buf[tone]=spkr_tone[midt];
	fwrite(buf,10,1,fd);
	fclose(fd);

	fclose(fd);
#endif
}
