/*
 * Copyright (c) 2002 pancake <pancake@phreaker.net>
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is included in WiStumbler2 package.
 *
 * $Id: guiabout.c,v 1.0 2003/11/15 15:54:29 pancake Exp $
 */

#include <stdio.h>
#include <strings.h>
#include <stdlib.h>

#if USE_GTK

#include <gtk/gtk.h>
#include "guimenu.h"
#include "main.h"
#define ABOUT_MSG \
"WiStumbler2 - pancake@phreaker.net\n\n"\
"Fork of the original WiStumbler for NetBSD coded by iseki.\n\n"\
"http://www.nopcode.org/?t=wistumbler2\n"

gboolean error_isopen=FALSE;
char *error_oldmsg=NULL;

void wistumbler_gui_closeerror(void*v)
{
	error_isopen=FALSE;
}

// <LINKED LIST>
struct message {
	char *text;
	struct message* next;
};

struct message *msg=0;
char *msg_text=0;

void error_enqueue(char *text)
{
	struct message *ptr;

	if (msg == NULL)
	{
		msg=(struct message*)malloc(sizeof(struct message));
		msg->next=0;
	}

	for (ptr=msg;ptr->next;)
		ptr=ptr->next; 
	ptr->text=strdup(text);
}

char *error_dequeue()
{
	struct message *ptr;
	char *text;

	if (msg == NULL)
		return (char*)0;
	ptr=msg;

	text=msg->text;
	msg=msg->next;
	free(ptr);

	msg_text=text;
	return text;
}
// </ LINKED LIST>

void wistumbler_gui_error(msg)
	char *msg;
{
	error_enqueue(msg);
}

void wistumbler_gui_clicked(void *w)
{
	if (msg_text)
	{
		free(msg_text);
		msg_text=0;
	}
	gtk_widget_destroy(w);
}

int wistumbler_gui_error_polling(void *xxx)
{
	GtkWidget *w,*msg_label,*vbox,*ok_button,*icon;
	char *msg;

	msg = error_dequeue();
	if (msg==NULL) // there's nothing to do
		return TRUE;

	if (!App.usex)
	{
		printf("MSG: %s\n",msg);
		return TRUE;
	}

	//if (error_isopen==TRUE)
	//{
	//printf("ISOPENED %s\n",msg);
	//	error_enqueue(msg);
	//	return TRUE;
	//}
	error_isopen=TRUE;

	/* Dont show two times the same error msg */
	if (error_oldmsg)
		if (!strcmp(error_oldmsg,msg)) return TRUE;
	if (error_oldmsg)
		free(error_oldmsg);
	error_oldmsg=strdup(msg);
	/* -- */

	w=gtk_window_new(GTK_WINDOW_TOPLEVEL); /* TODO parent */
	gtk_window_set_position(GTK_WINDOW(w), GTK_WIN_POS_CENTER);
	//  gtk_window_set_position(GTK_WINDOW(w), GTK_WIN_POS_CENTER_ON_PARENT);
	gtk_container_border_width(GTK_CONTAINER(w),5);
	//gtk_widget_set_parent(w,parent);
	gtk_window_set_title(GTK_WINDOW(w), "Error");
	gtk_widget_set_usize(GTK_WIDGET(w), 300,130);
	gtk_signal_connect(GTK_OBJECT(w), "destroy",
			GTK_SIGNAL_FUNC(wistumbler_gui_closeerror), NULL);
	vbox=gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(w),vbox);
	icon=gtk_image_new_from_stock("gtk-dialog-warning",GTK_ICON_SIZE_DIALOG);
	gtk_container_add(GTK_CONTAINER(vbox),icon);
	msg_label=gtk_label_new(msg);
	gtk_container_add(GTK_CONTAINER(vbox),msg_label);
	ok_button=gtk_button_new_from_stock(GTK_STOCK_OK);
	gtk_container_add(GTK_CONTAINER(vbox),ok_button);
	gtk_signal_connect_object(GTK_OBJECT(ok_button),"clicked",
			GTK_SIGNAL_FUNC(wistumbler_gui_clicked),(gpointer)w);

	gtk_widget_show_all(w);

	return TRUE;
}
#else
void wistumbler_gui_error(msg)
	char *msg;
{
	fprintf(stderr,"ERRORMSG: %s\n",msg);
}
#endif
