/*	$NetBSD: char.c,v 1.6 2009/04/14 08:50:06 lukem Exp $	*/

/*
 * Copyright (c) 1983, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Edward Wang at The University of California, Berkeley.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>
#ifndef lint
#if 0
static char sccsid[] = "@(#)char.c	8.1 (Berkeley) 6/6/93";
#else
__RCSID("$NetBSD: char.c,v 1.6 2009/04/14 08:50:06 lukem Exp $");
#endif
#endif /* not lint */

#include "char.h"

char _cmap[] = {
	_C|_U,		_C|_U,		_C|_U,		_C|_U,	/* ^@ - ^C */
	_C|_U,		_C|_U,		_C|_U,		_C|_U,	/* ^D - ^G */
	_C,		_C|_P,		_C,		_C|_U,	/* ^H - ^K */
	_C|_U,		_C,		_C|_U,		_C|_U,	/* ^L - ^O */
	_C|_U,		_C|_U,		_C|_U,		_C|_U,	/* ^P - ^S */
	_C|_U,		_C|_U,		_C|_U,		_C|_U,	/* ^T - ^W */
	_C|_U,		_C|_U,		_C|_U,		_C|_U,	/* ^U - ^[ */
	_C|_U,		_C|_U,		_C|_U,		_C|_U,	/* ^\ - ^_ */

	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,

	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,

	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_P|_U,
	_P|_U,		_P|_U,		_P|_U,		_C|_U,

	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,

	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,

	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,

	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U,
	_C|_U,		_C|_U,		_C|_U,		_C|_U
};

const char *_unctrl[] = {
	"^@",	"^A",	"^B",	"^C",	"^D",	"^E",	"^F",	"^G",
	"^H",	"^I",	"^J",	"^K",	"^L",	"^M",	"^N",	"^O",
	"^P",	"^Q",	"^R",	"^S",	"^T",	"^U",	"^V",	"^W",
	"^X",	"^Y",	"^Z",	"^[",	"^\\",	"^]",	"^^",	"^_",
	" ",	"!",	"\"",	"#",	"$",	"%",	"&",	"'",
	"(",	")",	"*",	"+",	",",	"-",	".",	"/",
	"0",	"1",	"2",	"3",	"4",	"5",	"6",	"7",
	"8",	"9",	":",	";",	"<",	"=",	">",	"?",
	"@",	"A",	"B",	"C",	"D",	"E",	"F",	"G",
	"H",	"I",	"J",	"K",	"L",	"M",	"N",	"O",
	"P",	"Q",	"R",	"S",	"T",	"U",	"V",	"W",
	"X",	"Y",	"Z",	"[",	"\\",	"]",	"^",	"_",
	"`",	"a",	"b",	"c",	"d",	"e",	"f",	"g",
	"h",	"i",	"j",	"k",	"l",	"m",	"n",	"o",
	"p",	"q",	"r",	"s",	"t",	"u",	"v",	"w",
	"x",	"y",	"z",	"{",	"|",	"}",	"~",	"^?",
	"\\200","\\201","\\202","\\203","\\204","\\205","\\206","\\207",
	"\\210","\\211","\\212","\\213","\\214","\\215","\\216","\\217",
	"\\220","\\221","\\222","\\223","\\224","\\225","\\226","\\227",
	"\\230","\\231","\\232","\\233","\\234","\\235","\\236","\\237",
	"\\240","\\241","\\242","\\243","\\244","\\245","\\246","\\247",
	"\\250","\\251","\\252","\\253","\\254","\\255","\\256","\\257",
	"\\260","\\261","\\262","\\263","\\264","\\265","\\266","\\267",
	"\\270","\\271","\\272","\\273","\\274","\\275","\\276","\\277",
	"\\300","\\301","\\302","\\303","\\304","\\305","\\306","\\307",
	"\\310","\\311","\\312","\\313","\\314","\\315","\\316","\\317",
	"\\320","\\321","\\322","\\323","\\324","\\325","\\326","\\327",
	"\\330","\\331","\\332","\\333","\\334","\\335","\\336","\\337",
	"\\340","\\341","\\342","\\343","\\344","\\345","\\346","\\347",
	"\\350","\\351","\\352","\\353","\\354","\\355","\\356","\\357",
	"\\360","\\361","\\362","\\363","\\364","\\365","\\366","\\367",
	"\\370","\\371","\\372","\\373","\\374","\\375","\\376","\\377"
};
