#ifndef _DEFAULTS_H
#define _DEFAULTS_H

#include <FL/Fl_Slider.H>
#include "tuxpaint-config2.h"


extern void DEF_videoandsound();
extern void DEF_mouseandkeyboard();
extern void DEF_simplification();
extern void DEF_locale();
extern void DEF_printing();
extern void DEF_saving();
extern void DEF_data();
extern void DEF_accessibility();
extern void DEF_joystick();

extern bool CHKBUT_fulls_isdef();
extern bool RNDBUT_scrnsz_isdef();
extern bool CHKBUT_fancycursors_isdef();
extern bool CHKBUT_grabmouse_isdef();
extern bool CHKBUT_mousewheelsup_isdef();
extern bool CHKBUT_enablekb_isdef();
extern bool CHKBUT_norots_isdef();
extern bool CHKBUT_smploutlns_isdef();
extern bool CHKBUT_showUConly_isdef();
extern bool CHKBUT_disablequit_isdef();
extern bool CHKBUT_mirstamps_isdef();
extern bool CHKBUT_allowprint_isdef();
extern bool VALINP_printdel_isdef();
extern bool BROWSER_uifont_isdef();
extern bool CHKBUT_altsavedir_isdef();
extern bool CHKBUT_altexportdir_isdef();
extern bool CHKBUT_altdatadir_isdef();

extern void CB_SetActualTabToDefaults();
extern void CB_SetAllTabsToDefaults();

extern bool status_chng;
extern void set_change_status(int status);

#define BTN_SIZE_DEFAULT /* Button size option: don't overrdide */ gettext("Button size: 48x48 (default; no override)")
extern void cb_SLIDER_buttonsize(Fl_Slider *, void *);

#define COLOR_SIZE_DEFAULT /* Color palette size option: don't override */ gettext("Color palette rows: 1 (default)")
extern void cb_SLIDER_colorsrows(Fl_Slider *, void *);

#define STAMP_SIZE_DEFAULT /* Stamp size option: don't override */ gettext("Default (no override)")
extern void cb_SLIDER_stampsize(Fl_Slider *, void *);

extern void update_canvas_size(void);

enum
{
  WW_640,
  WW_768,
  WW_800,
  WW_854,
  WW_1024,
  WW_1280,
  WW_1400,
  WW_1600,
  WW_1680,
  WW_1920,
  WW_2048,
  WW_2560,
  NUM_WINDOW_WIDTHS
};

enum
{
  WH_480,
  WH_576,
  WH_600,
  WH_720,
  WH_768,
  WH_800,
  WH_960,
  WH_1024,
  WH_1050,
  WH_1080,
  WH_1200,
  WH_1536,
  WH_1600,
  WH_2048,
  NUM_WINDOW_HEIGHTS
};

/* Values set in `defaults.cxx` */
extern const char *window_widths[NUM_WINDOW_WIDTHS];
extern const char *window_heights[NUM_WINDOW_HEIGHTS];

#define DEF_WINDOW_WIDTH WW_800
#define DEF_WINDOW_HEIGHT WH_600

#define UIFONT_NOCHANGE 1
#define UIFONT_MANUAL 2
#define UIFONT_FIRST_REAL_ENTRY 3

#endif
