// +build !binary_log

package diode_test

import (
	"fmt"
	"os"

	"tuxpa.in/a/zlog"
	"tuxpa.in/a/zlog/diode"
)

func ExampleNewWriter() {
	w := diode.NewWriter(os.Stdout, 1000, 0, func(missed int) {
		fmt.Printf("Dropped %d messages\n", missed)
	})
	log := zlog.New(w)
	log.Print("test")

	w.Close()

	// Output: {"level":"debug","message":"test"}
}
