/*
 *  SPL - The SPL Programming Language
 *  Copyright (C) 2004, 2005  Clifford Wolf <clifford@clifford.at>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  mod_kde.c: A wrapper for loading the Qt bindings with KDE support
 */

/**
 * A module for the KDE/Qt bindings
 *
 * This module simply loads the qt module with additional support for the KDE
 * API. It mus be loaded before the "qt" module.
 */

#define _GNU_SOURCE

#include <stdlib.h>
#include "spl.h"
#include "compat.h"

extern void SPL_ABI(spl_mod_kde_init)(struct spl_vm *vm, struct spl_module *mod, int restore);
extern void SPL_ABI(spl_mod_kde_done)(struct spl_vm *vm, struct spl_module *mod);

void SPL_ABI(spl_mod_kde_init)(struct spl_vm *vm, struct spl_module *mod UNUSED, int restore)
{
	struct spl_module *m = vm->module_list;

	while (m) {
		if (!strcmp("qt", m->name)) {
			spl_report(SPL_REPORT_HOST, vm, "The 'kde' module "
				"must be loaded before the 'qt' module!\n");
			exit(-1);
		}
		m = m->next;
	}

	if (!restore)
		spl_module_load(vm, "qt", 0);
}

void SPL_ABI(spl_mod_kde_done)(struct spl_vm *vm UNUSED, struct spl_module *mod UNUSED)
{
	return;
}

