/*--------------------------------------------------------------------------
 *  Copyright 2011 Taro L. Saito
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *--------------------------------------------------------------------------*/
//--------------------------------------
// XerialJ
//
// WeaverMain.java
// Since: 2011/02/03 17:44:54
//
// $URL$
// $Author$
//--------------------------------------
package org.xerial.silk.weaver.cui;

import org.xerial.util.log.Logger;
import org.xerial.util.opt.CommandLauncher;

/**
 * CUI main class of the silk-weaver
 * 
 * @author leo
 * 
 */
public class WeaverMain
{
    private static Logger _logger = Logger.getLogger(WeaverMain.class);

    public static void execute(String[] args) {

        CommandLauncher c = new CommandLauncher();
        c.addCommandsIn(WeaverMain.class.getPackage());

        try {
            c.execute(args);
        }
        catch (Exception e) {
            _logger.error(e);
        }
    }

    public static void main(String[] args) {

        execute(args);
    }
}
