/* ISC license. */

#include <stdint.h>

#include <shibari/util.h>

static char const *const qtype_table[262] =
{
  "error",
  "A",
  "NS",
  "MD",
  "MF",
  "CNAME",
  "SOA",
  "MB",
  "MG",
  "MR",
  "NULL",
  "WKS",
  "PTR",
  "HINFO",
  "MINFO",
  "MX",
  "TXT",
  "RP",
  "AFSDB",
  "X25",
  "ISDN",
  "RT",
  "NSAP",
  "NSAP-PTR",
  "SIG",
  "KEY",
  "PX",
  "GPOS",
  "AAAA",
  "LOC",
  "NXT",
  "EID",
  "NIMLOC",
  "SRV",
  "ATMA",
  "NAPTR",
  "KX",
  "CERT",
  "A6",
  "DNAME",
  "SINK",
  "OPT",
  "APL",
  "DS",
  "SSHFP",
  "IPSECKEY",
  "RRSIG",
  "NSEC",
  "DNSKEY",
  "DHCID",
  "NSEC3",
  "NSEC3PARAM",
  "TLSA",
  "SMIMEA",
  "unassigned",
  "HIP",
  "NINFO",
  "RKEY",
  "TALINK",
  "CDS",
  "CDNSKEY",
  "OPENPGPKEY",
  "CSYNC",
  "ZONEMD",
  "SVCB",
  "HTTPS",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "SPF",
  "UINFO",
  "UID",
  "GID",
  "UNSPEC",
  "NID",
  "L32",
  "L64",
  "LP",
  "EUI48",
  "EUI64",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "unassigned",
  "TKEY",
  "TSIG",
  "IXFR",
  "AXFR",
  "MAILB",
  "MAILA",
  "*",
  "URI",
  "CAA",
  "AVC",
  "DOA",
  "AMTRELAY",
  "RESINFO"
} ;


char const *shibari_util_qtype_str (uint16_t qtype)
{
  if (qtype < 262) return qtype_table[qtype] ;
  if (qtype < 32768) return "unassigned" ;
  if (qtype == 32768) return "TA" ;
  if (qtype == 32769) return "DLV" ;
  if (qtype < 65279) return "unassigned" ;
  if (qtype < 65535) return "private" ;
  return "reserved" ;
}
