/*
 * Copyright (C) 1983-1989  Masatoshi Kurihara <kurihara@sra.co.jp>
 * Copyright (C) 1999, 2000 and 2001
 * Jun-ichiro itojun Hagino <itojun@iijlab.net>
 * All rights reserved.
 *
 * Note well: this is not a normal 3-clause BSD copyright;
 * commercial use of the software is restricted.
 *
 * Redistribution and non-commercial use in source and binary
 * forms, with or without modification, are permitted provided that the
 * following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* Copyright (C) 1985 - 1989 by Software Research Associates, Inc. */

/* windows */
extern WINDOW *errwin;	/* error message*/
extern WINDOW *schwin;	/* schedule */
extern WINDOW *calwin;	/* calander */
extern WINDOW *schfull;	/* schedule full window */
extern WINDOW *schhalf;	/* schedule half window */

/* flags */
extern int updated;	/* file should be write back */
extern int prjsw;	/* project code print */
extern int calsw;	/* calander */
extern int autowrite;	/* auto write back */
extern int writesw;	/* write permission */
extern int newsw;	/* new file */
extern int msgsw;	/* message on bottom line */
extern int myfile;	/* other user's schedule */
extern int verbose;
extern int tabhour;	/* tab advances N hours */
extern int hourwidth;	/* 1 hour = N chars */
extern int homezone;	/* home timezone offset against GMT, Japan = -9 */
extern int curzone;	/* display/edit timezone offset against GMT */
extern int oldformat;	/* write out in old format */

extern int scrmsg;	/* Start column of message */
extern int maxsch, cursch;	/* Pointer for schedule data */
extern long ltime;	/* Start time */
extern struct tm inttimebuf;	/* Start time */
extern struct tm *inttime;	/* Start time */

extern int daystart;	/* day starts at this hour */
extern int dayend;	/* day ends in this hour */

/* Terminal control character */
#ifdef HAVE_TERMIOS_H
extern struct termios tio;
#else
extern struct sgttyb ttyb;
#endif

extern struct sch *sch[MAXDATA];	/* schedule buffer */

/* Yanked shedule data */
struct	yank {
	char	work[12];		/* work time */
	char	prj[4];			/* project code */
#ifndef MULTIBYTE
	char	msg[LEN_MESG];		/* message */
#else
	wchar_t	msg[LEN_MESG];		/* message */
#endif
};
extern struct yank yank[10];		/* yank buffer */
extern char schfname[MAXPATHLEN];	/* Schedule file name */
extern char schsname[MAXPATHLEN];	/* Schedule file short name */
extern char username[10];		/* Target user name */
extern int mark[10];			/* Marked shedule data */
#define validmark(x)	((x) >= 0 && (x) < maxsch)

#ifdef HAVE_REGEX_H
extern regex_t *psearch;
#else
extern struct regexp *psearch;
#endif

#ifdef OPT_STRLEN
extern char localelang[OPT_STRLEN];
#endif
extern int localeset;
