/*
 * Copyright (C) 1983-1989  Masatoshi Kurihara <kurihara@sra.co.jp>
 * Copyright (C) 1999, 2000 and 2001
 * Jun-ichiro itojun Hagino <itojun@iijlab.net>
 * All rights reserved.
 *
 * Note well: this is not a normal 3-clause BSD copyright;
 * commercial use of the software is restricted.
 *
 * Redistribution and non-commercial use in source and binary
 * forms, with or without modification, are permitted provided that the
 * following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _HAVE_ENTRY_H
#define _HAVE_ENTRY_H

#define	LEN_MESG	60		/* message field */

/* schedule data */
struct	sch {
	int year;			/* year */
	int month;			/* month */
	int day;			/* day */
	int sthour;			/* start hour */
	int stmin;			/* start minuete */
	int enhour;			/* end hour */
	int enmin;			/* end minuete */
	char work[12];			/* work time */
	char prj[4];			/* project code */
#ifndef MULTIBYTE
	char msg[LEN_MESG];		/* message */
#else
	wchar_t	msg[LEN_MESG];		/* message */
#endif
};

extern struct sch *sch_new __P((void));
extern void sch_free __P((struct sch *));
extern int sch_wday __P((struct sch *, int));
extern struct sch *sch_oparse __P((char *));
extern void sch_oprint __P((FILE *, struct sch *));
extern struct sch *sch_parse __P((char *));
extern void sch_print __P((FILE *, struct sch *));
#if defined(HAVE_OFFTIME) && defined(HAVE_TIMEOFF)
extern void sch_tznorm __P((struct sch *, int, int));
#endif
extern void sch_dayoffset __P((struct sch *, int));

#define OPUT_FORM \
	"%2d/%2.2d: %2.2d:%2.2d-%2.2d:%2.2d %-11.11s %-3.3s %s\n"
#define PUT_FORM \
	"%04d/%02d/%02d: %2.2d:%2.2d-%2.2d:%2.2d %-11.11s %-3.3s %s\n"

#endif /*_HAVE_ENTRY_H*/
