/*--------------------------------------------------------
  main.c - main routine for rtspd.

--------------------------------------------------------*/


/*--------------------------------------------------------

REALNETWORKS LICENSE AGREEMENT AND WARRANTY 
             DISCLAIMER

_____________________________________________

Free Real-Time Streaming Protocol (RTSP) Firewall 
             Proxy License

IMPORTANT -- READ CAREFULLY: This RealNetworks 
License Agreement ("License Agreement") is a legal 
agreement between you (either an individual or an 
entity) and RealNetworks, Inc.  and its suppliers and 
licensors collectively ("RN") for the software product 
listed above, which includes computer software and 
associated media and printed material, whether provided 
in a physical form or received on-line form ("Software").  
By clicking on the "Accept" button or opening the 
package, you are consenting to be bound by this Agreement.  
If you do not agree to all of the terms of this agreement, 
click the "Do Not Accept" button and, if you received the 
Software by package, return the product to the place of 
purchase.

__________________________________________________________

1. GRANT OF LICENSE.

Subject to the provisions contained in this License Agreement, 
RN hereby grants you a non-exclusive, non-transferable, 
perpetual, worldwide license to use, modify or redistribute the 
Software subject to the following terms and conditions:

(a) The copyright notice (" 1998 RealNetworks, 
Inc.") and this copy of  this License Agreement shall 
appear on all copies and/or any derivative versions 
of the Software you create or distribute.

(b)	You acknowledge and agree that RN is and shall be 
the exclusive owner of all right, title and interest, 
including copyright, in the Software.

All rights not expressly granted to you are reserved to RN.

2.  SOFTWARE MAINTENANCE AND UPGRADES. 

RN is not obligated to provide maintenance or updates to you 
for the Software. However, any maintenance or updates 
provided by RN shall be covered by this Agreement.

3.  DISCLAIMER OF WARRANTY.

The Software is deemed accepted by you.  Because RN is 
providing you the Software for free, the Software is provided 
to you AS IS, WITHOUT WARRANTY OF ANY KIND. TO 
THE MAXIMUM EXTENT PERMITTED BY 
APPLICABLE LAW, REALNETWORKS FURTHER 
DISCLAIMS ALL
WARRANTIES, INCLUDING WITHOUT LIMITATION 
ANY IMPLIED WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE, AND NONINFRINGEMENT. THE ENTIRE 
RISK ARISING OUT OF THE USE OR PERFORMANCE 
OF THE SOFTWARE REMAINS WITH YOU. TO THE 
MAXIMUM EXTENT PERMITTED BY APPLICABLE 
LAW, IN NO
EVENT SHALL REALNETWORKS OR ITS SUPPLIERS 
BE LIABLE FOR ANY CONSEQUENTIAL, INCIDENTAL, 
DIRECT, INDIRECT, SPECIAL, PUNITIVE, OR OTHER 
DAMAGES WHATSOEVER (INCLUDING, WITHOUT 
LIMITATION, DAMAGES FOR LOSS OF BUSINESS 
PROFITS, BUSINESS INTERRUPTION, LOSS OF 
BUSINESS INFORMATION, OR OTHER PECUNIARY 
LOSS) ARISING OUT OF THIS AGREEMENT OR THE 
USE OF OR INABILITY TO USE THE SOFTWARE, EVEN 
IF REALNETWORKS HAS BEEN ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGES. BECAUSE SOME 
STATES/JURISDICTIONS DO NOT ALLOW THE 
EXCLUSION OR LIMITATION OF LIABILITY FOR 
CONSEQUENTIAL OR INCIDENTAL DAMAGES, THE 
ABOVE LIMITATION MAY NOT APPLY TO YOU.

4. INDEMNIFICATION. 

You hereby agree to defend, indemnify, and hold RN, its 
directors, officers, employees and agents, harmless from any 
and all claims, damages, and expenses (including attorneys 
fees and costs) of any nature arising out of the use, 
modification, or redistribution the Software or any derivative 
versions thereof.

5. U.S. GOVERNMENT RESTRICTED RIGHTS AND 
EXPORT RESTRICTIONS. 

The Software is provided with RESTRICTED RIGHTS. Use, 
duplication, or disclosure by the Government is subject to 
restrictions as set forth in subparagraph (a) through (d) of the 
of the Commercial Computer Software-Restricted Rights at 
FAR 52.227-19, as applicable, or subparagraph (c)(1)(ii) of 
The Rights in Technical Data and Computer Software clause 
of DFARS 252.227-7013, and in similar clauses in the NASA 
FAR supplement, as applicable.  Manufacturer is 
RealNetworks, Inc., 1111 Third Avenue, Suite 500, Seattle, 
Washington 98101.  You acknowledge that none of the 
Software or underlying information or technology may be 
downloaded or otherwise exported or re-exported (i) into (or 
to a national or resident of) Cuba, Iraq, Libya, Yugoslavia, 
North Korea, Iran, Syria, Sudan or Angola or any other 
country to which the U.S. has embargoed goods; or (ii) to 
anyone on the U.S. Treasury Department's list of Specially 
Designated Nationals or the U.S. Commerce Department's 
Table of Denial Orders.  By using the Software, you are 
agreeing to the foregoing and you are representing and 
warranting that you are not located in, under the control of, or 
a national or resident or resident of any such country or on any 
such list.

6. GOVERNING LAW; ATTORNEYS FEES. 

This agreement shall be governed by the laws of the State of 
Washington and you further consent to jurisdiction by the state 
and federal courts sitting in the State of Washington. If either 
RN or you employs
attorneys to enforce any rights arising out of or relating to this 
Agreement, the prevailing party shall be entitled to recover 
reasonable attorneys' fees.

8.  ENTIRE AGREEMENT. 

This agreement constitutes the complete and exclusive 
agreement between RN and you with respect to the subject 
matter hereof, and supersedes all prior oral or written 
understandings, communications or agreements not 
specifically incorporated herein.  This agreement may not be 
modified except in a writing duly signed by an authorized 
representative of RN and you.    

Copyright  1997-1998 RealNetworks, Inc. and or its 
suppliers.  1111 Third Avenue, Suite 2900, Seattle, 
Washington 98101 U.S.A.  All rights are reserved.



RTSP Proxy License Agreement 8-98

--------------------------------------------------------*/



#include <stdio.h>
#include <strings.h>
#ifdef NEED_STRING_H
#include <string.h>
#endif /* NEED_STRING_H */
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include <pwd.h>
#include <netdb.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/errno.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <errno.h>


#include "daemon.h"
#include "child-main.h"
#include "util.h"
#include "simplib.h"
#include "setup.h"


/* a possible return value of inet_addr() */
#if !defined (INADDR_NONE)
#define INADDR_NONE (-1)
#endif /* !defined (INADDR_NONE) */



/* prototypes */
static void     usage            (char *prog, char *opt);
static void     server           (u_short port, char *username);
static void     handle_sigchild  (int signum);
static void     try_setuid       (char *username);


/* this is for forwarding all traffic to another proxy. */
char proxy_forward_host[HOSTNAME_MAX+1] = "";
int proxy_forward_port = SERV_TCP_PORT; /* by default, send to same as we
                                           listen to. */

/* Do a chroot() to this directory before starting, for security (see -c) */
#define CHROOT_DIR_MAX PATH_MAX
static char chroot_dir[CHROOT_DIR_MAX+1] = "";
/* setuid to this user after doing the chroot (see -u) */
#ifndef USERNAME_MAX
#define USERNAME_MAX 16
#endif /* USERNAME_MAX */
char setuid_user[USERNAME_MAX+1] = "";


/* print VERSION string */
#ifdef DEBUG
#define show_version() fprintf (stderr, "%s\nDEBUG build\n", VERSION_MESSAGE)
#else
#define show_version() fprintf (stderr, "%s\n", VERSION_MESSAGE)
#endif /* DEBUG */

/* Proxy machine's IP address */
struct hostent *get_host_info();
struct hostent *proxy_host=NULL;

unsigned int server_port = SERV_TCP_PORT;


/*----------------------------------------------------------------------
   main() -- The main routine.

   Paramaters:
     argc - argument count
     argv - argument list

   Return:  nothing (exits before returning)
----------------------------------------------------------------------*/
int
main (int argc, char *argv[])
{
  int arg=0;
  char *p=NULL;
  int hostlen=0;
  extern char *optarg;

  /* parse the command line arguments */
  while ((arg = getopt (argc, argv, "?c:f:hp:u:v")) != EOF)
    {
      switch (arg)
	{
	case 'p':	/* The port to listen to */
	  server_port = atoi (optarg);
	  if (server_port <= 0)
	    {
              /* maybe port is a name from /etc/services not just a number */
              struct servent *sptr = getservbyname (optarg, "tcp");
              if (sptr)
              {
                server_port = ntohs(sptr->s_port);
                break;
              }
	      fprintf (stderr, "Invalid port: %d\n", server_port);
	      usage (argv[0], NULL);
	    }
	  break;

	case 'f':	/* A host:port to forward outgoing traffic to.
                           We also allow -f host, forwarding to default
                           port on the remote host */
          if ((p = index (optarg, ':')) != NULL)
            {
              hostlen = p - optarg;
	      proxy_forward_port = atoi(p+1);
            }
          else
            {
              hostlen = strlen (optarg);
            }
          if (hostlen >= HOSTNAME_MAX)
            {
              fprintf (stderr, "Error: hostname for -p is too long\n");
	      usage (argv[0], NULL);
            }
          if (hostlen <= 0)
            {
	      fprintf (stderr, "Invalid proxy forwarding host: %s\n",
			optarg);
	      usage (argv[0], NULL);
            }
	  strncpy (proxy_forward_host, optarg, hostlen);
	  proxy_forward_host[hostlen] = '\0';

	  if (proxy_forward_port <= 0 && p != NULL)
	    {
              /* maybe port is a name from /etc/services not just a number */
              struct servent *sptr = getservbyname (p+1, "tcp");
              if (sptr)
              {
                proxy_forward_port = ntohs(sptr->s_port);
              }
              else
              {
	        fprintf (stderr, "Invalid proxy forwarding port: %d\n",
			 proxy_forward_port);
	        usage (argv[0], NULL);
              }
	    }
          /* log_message (DEBUG_LOG, "hostlen=%d fport=%d p=%x fhost=%s", hostlen, proxy_forward_port, p, proxy_forward_host); */
	  break;

	case 'c':
	  strncpy (chroot_dir, optarg, CHROOT_DIR_MAX);
	  chroot_dir[CHROOT_DIR_MAX] = '\0';
	  log_message (DEBUG_LOG, "calling chroot(%s)\n", chroot_dir);
	  if (chroot (chroot_dir) != 0)
		exit_proxy (EXIT_CHROOT_ERROR);
	  break;

	case 'u':
	    /* just save it for later since we want to be sure we chroot first*/
	  strncpy (setuid_user, optarg, USERNAME_MAX);
          setuid_user[USERNAME_MAX] = '\0';
	  break;

	case 'v':
          show_version();
          exit_proxy (EXIT_VERSION);
	  break;

	case 'h':
	case '?':
	  usage (argv[0], NULL);
	  break;
	}
    }


  /* If we're root we want to setuid to "nobody" if nothing else specified */
  if (setuid_user[0] == '\0' && geteuid() == 0)
    strcpy (setuid_user, DEFAULT_SETUID_USER);


  log_message (INFO_LOG, VERSION_MESSAGE);

  /* become a daemon process */
#if !defined (DEBUG) && !defined (ONCE_ONLY)
  daemon_start ();
#endif /* !DEBUG && !ONCE_ONLY */


  /* handle dead children */
  set_signal_handler (SIGCHLD, handle_sigchild);

  server (server_port, setuid_user);
  exit_proxy (EXIT_NORMAL);

  return 1;
}



/*----------------------------------------------------------------------
   usage() -- Print usage information.
   Paramaters:
     prog - The name of this program
     opt  - An invalid command-line option (if the user supplied one).

   Return:  nothing (exits before returning)
----------------------------------------------------------------------*/
static void 
usage (char *prog, char *opt)
{
  show_version();

  if (opt)
    fprintf (stderr, "%s: %s\n", prog, opt);

  fprintf (stderr, "usage: %s [-p port] [-f rhost:rport] [-c dir] [-u user] [-h] [-v]\n", prog);
  fprintf (stderr, "    -p port         Run as a server bound to the specified port (default: %d).\n", SERV_TCP_PORT);
  fprintf (stderr, "    -f rhost:rport  Forward all to another proxy at the specified host/port.\n");
  fprintf (stderr, "    -c dir          Perform a chroot() to the specified directory.\n");
  fprintf (stderr, "    -u user         Change to the specified user at startup.\n");
  fprintf (stderr, "    -h              Display this help message.\n");
  fprintf (stderr, "    -v              Print version information.\n");

  exit_proxy (EXIT_USAGE);

}



/*----------------------------------------------------------------------
   server() -- Set up a network socket and listen to connection requests.
   Paramaters:
     port - The port to listen to.
     username - The user to setuid to.

   Return:  nothing (exits before returning)

   This listens for new clients trying to connect, and hands these new
   connections off to another process to handle, then returns to listening
   for new connections again.
----------------------------------------------------------------------*/
static void
server (u_short port, char *username)
{
  int newsockfd=0, serverfd=0;
  ADDRESS_LENGTH clilen=0;
  struct sockaddr_in cli_addr, serv_addr;

  /* record DNS information about the host the proxy is running on */
  proxy_host = get_host_info();

  /* open a TCP socket */
  if ((serverfd = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    exit_proxy (EXIT_SOCKET_CREATE_ERROR);

  log_message (DEBUG_LOG, "Server on FD: %d", serverfd);

  /* bind local address  */
  bzero ((char *)&serv_addr, sizeof (serv_addr));
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = htonl (INADDR_ANY);
  serv_addr.sin_port = htons (port);


  if (bind (serverfd, (struct sockaddr *)&serv_addr, sizeof (serv_addr)) < 0)
  {
    exit_proxy (EXIT_BIND_ERROR);
  }


  listen (serverfd, 5);
  clilen = sizeof (cli_addr);


  /* now that we've bound to the port we can try to setuid */
  if (username[0] != '\0')
    try_setuid (username);

  if (geteuid() == 0)
  {
    log_message (ERROR_LOG, "Warning!  RTSPD is running as super-user!\n");
     /* exit_proxy (EXIT_GENERIC_ERROR); */
  }



  while (1)
    {

          /* Listen for a new RTSP connection from a client */
	  newsockfd = accept (serverfd, (struct sockaddr *) &cli_addr, &clilen);


	  if (newsockfd < 0)
	    {
	      
	      switch (errno) {
#ifdef EPROTO
	      case EPROTO:
#endif /* EPROTO */
#ifdef ECONNABORTED
	      case ECONNABORTED:
#endif /* ECONNABORTED */
#ifdef ECONNRESET
	      case ECONNRESET:
#endif /* ECONNRESET */
#ifdef ETIMEDOUT
	      case ETIMEDOUT:
#endif /* ETIMEDOUT */
#ifdef EHOSTUNREACH
	      case EHOSTUNREACH:
#endif /* EHOSTUNREACH */
#ifdef ENETUNREACH
	      case ENETUNREACH:
#endif /* ENETUNREACH */
#ifdef EINTR
	      case EINTR:
#endif /* EINTR */
		break;  /* these are all things we can ignore */

		
	      default:  /* everything else causes us to exit */
		exit_proxy (EXIT_ACCEPT_ERROR);
	      }


	      continue;
	    }



/* if ONCE_ONLY is defined we only listen for one RTSP connection and
   handle it, exiting when we're done.  We do not start a daemon to
   handle more connections.  This is intended for debugging/testing only.
 */
#ifndef ONCE_ONLY
	if (fork() == 0)
#endif /* ONCE_ONLY */
	  {
	    child_main (newsockfd);
	    exit_proxy (EXIT_NORMAL);
	  }

	close (newsockfd);

    } /* while (1) */
}



/*----------------------------------------------------------------------
   handle_sigchild() -- A signal handler for SIGCHLD.
   Paramaters:
     signum - The signal that triggered the handler

   Return:  nothing

   Waits for zero or more children processes to exit.
----------------------------------------------------------------------*/
static void
handle_sigchild (int signum)
{
  int     status=0;

  /* log_message (DEBUG_LOG, "child process completed"); */

  while (1)
  {
	if (waitpid((pid_t)(-1), &status, WNOHANG) <= 0)
	   return;
  }
  
}



/*----------------------------------------------------------------------
   try_setuid() -- Attempt to setuid() to a given user.
   Paramaters:
     username - The user to setuid() to.

   Return:
     nothing
     exits before returning on error
----------------------------------------------------------------------*/
static void
try_setuid (char *username)
{
  struct passwd *pw = NULL;

  if (username[0] != '\0')
  {
  	log_message (DEBUG_LOG, "Calling setuid(%s)\n", username);

  	if ( ! (pw = getpwnam(username)) )
  		exit_proxy (EXIT_UNKNOWN_USER_ERROR);

  	if (pw->pw_uid <= 0)
  		exit_proxy (EXIT_BAD_USER_ERROR);

  	if (setuid (pw->pw_uid) != 0)
  	exit_proxy (EXIT_SETUID_ERROR);

  	log_message (DEBUG_LOG, "setuid result: getuid=%d geteuid=%d\n",
                     getuid(), geteuid());
  }
}



/*----------------------------------------------------------------------
  get_host_info() - Get TCP/IP address info about the host we're running on.

  Paramaters:
    none

  Return:
    A pointer to a struct hostent structure with the desired information.
----------------------------------------------------------------------*/
struct hostent *
get_host_info()
{
  char hostname[HOSTNAME_MAX+1];
  struct hostent *host=NULL;
  struct hostent *host2=NULL;
  unsigned long ip=0;

  /* Look up the hostname of this host */
  gethostname (hostname, HOSTNAME_MAX);

  /* perform a blocking DNS lookup on hostname */
  if (((ip = inet_addr(hostname)) == INADDR_NONE)  &&
      (strcmp(hostname, "255.255.255.255") != 0))
    {                                                     
      if ((host = gethostbyname(hostname)) != NULL)
        {                                  
          memcpy(&ip, host->h_addr, sizeof(ip));
        }
      endhostent();                          
    }

  /* make a copy of the hostent structure */
  host2 = g_malloc (sizeof (struct hostent));
  memcpy (host2, host, sizeof (struct hostent));

  log_message (DEBUG_LOG, "DNS LOOKUP %s -> 0x%08lx", hostname, ip);

  return host2;

}


