/*  $Id: util.cpp,v 1.1 2012/07/08 09:35:54 sarrazip Exp $
    util.cpp - Utility functions.

    quadrupleback - A video game where intruders must be circled.
    Copyright (C) 2012 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
    02110-1301, USA.
*/

#include "util.h"

using namespace flatzebra;
using namespace std;


// Source: http://local.wasp.uwa.edu.au/~pbourke/geometry/lineline2d/
//
bool
segmentIntersection(double &xi, double &yi,
                    double &coef0, double &coef1,
                    double x1, double y1,
                    double x2, double y2,
                    double x3, double y3,
                    double x4, double y4)
{
    double denom = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
    if (denom == 0)
        return false;  // parallel lines

    double numA = (x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3);
    double numB = (x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3);
    double uA = numA / denom;
    double uB = numB / denom;
    /*if (trace)
        cout << "\t  segmentIntersection: "
                << "uA=" << uA //<< " [" << (uA >= 0) << ", " << (uA <= 1) << "]"
                << "; "
                << "uB=" << uB //<< " [" << (uB >= 0) << ", " << (uB <= 1) << "]"
                << endl;*/
    if (uA >= 0 && uA <= 1 && uB >= 0 && uB <= 1)  // if intersection is on both segments
    {
        // Return the actual intersection point.
        xi = x1 + uA * (x2 - x1);
        yi = y1 + uA * (y2 - y1);
        coef0 = uA;
        coef1 = uB;
        return true;
    }
    return false;  // no intersection
}


// Source: Darel Rex Finley, "Point-In-Polygon Algorithm -- Determining Whether
// A Point Is Inside A Complex Polygon", http://alienryderflex.com/polygon/, 2007.
//
bool
isPointInPolygon(const RCouple &pt, const vector<RCouple> &polygon)
{
    size_t numPts = polygon.size();
    if (numPts == 0)
        return false;

    bool isInside = false;
    size_t j = numPts - 1;
    for (size_t i = 0; i < numPts; ++i)
    {
        assert(i == (j + 1) % numPts);
        const RCouple &cur  = polygon[i];
        const RCouple &prev = polygon[j];
        if (prev != cur && pt.isOnSegment(prev, cur))
            return true;

        if (((cur.y <= pt.y && pt.y < prev.y) || (prev.y <= pt.y && pt.y < cur.y)) &&
                pt.x < (prev.x - cur.x) * (pt.y - cur.y) / (prev.y - cur.y) + cur.x)
            isInside = !isInside;

        j = i;
    }
    return isInside;
}
