/*  $Id: Enemy.h,v 1.1 2012/07/08 09:35:52 sarrazip Exp $
    Enemy.h - Object to be circled.

    quadrupleback - A video game where intruders must be circled.
    Copyright (C) 2012 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
    02110-1301, USA.
*/

#ifndef _H_Enemy
#define _H_Enemy

#include "util.h"

#include <flatzebra/RSprite.h>


class Enemy
{
public:

    enum Type
    {
        CHERRY,
        APPLE,
        PEAR,
        HORSESHOE,
        SKULL,
        SKATE,
        SPIDER,
        YOYO,
        NUM_ENEMY_TYPES
    };


    static Type chooseRandomly();

    static const unsigned short typeDistribution0[NUM_ENEMY_TYPES];


    // _sprite: must come from 'new' and NOT be null.
    // Also call setYoyoMaxLength() when creating a yoyo.
    //
    Enemy(Type _type,
          flatzebra::RSprite *_sprite,
          const char **_xpm,
          double _speed,
          size_t _tickOfDeath);

    // Destroys the RSprite object passed to the constructor.
    //
    ~Enemy();

    Type getType() const;

    bool touchesPosition(const flatzebra::RCouple &p) const;

    bool isTimeToChangeTarget(size_t currentTick) const;

    void setTargetPos(const flatzebra::RCouple &p, size_t timeOfNextChange);

    flatzebra::RCouple getTargetPos() const;

    bool movesHorizOnly() const;

    // Get the position of the point that must be inside a loop
    // for this enemy to be captured.
    // The position is relative to the "game area", not to the whole window.
    //
    flatzebra::RCouple getCapturePos() const;

    double getSpeed() const;

    long getPointValue() const;

    // Tick at which this enemy dies; size_t(-1) means no automatic death.
    //
    size_t getTickOfDeath() const;

    // Number of ticks before sprite animation changes.
    // Always positive.
    //
    size_t getAnimationFreq() const;

    void updatePixmapIndex();

    void setYoyoMaxLength(double maxLengthInPixels);

    double getYoyoLength() const;

    // Returns new yoyo length (in pixels).
    //
    void animateYoyo();

    // wireTopLeft: relative to game area.
    //
    void getWireRect(flatzebra::RCouple &wireTopLeft, flatzebra::RCouple &wireSize) const;

    bool isCapturedByLoop(const std::vector<flatzebra::RCouple> &loop) const;

private:

    // Forbidden operations:
    Enemy(const Enemy &);
    Enemy &operator = (const Enemy &);

public:

    Type type;
    flatzebra::RSprite *sprite;
    const char **xpmPixels;  // points to 1st pixel row of XPM
    double speed;
    size_t tickOfDeath;
    flatzebra::RCouple targetPos;  // point towards which this enemy moves
    size_t targetChangeTime;  // time in ticks when target position should be changed

    // Only relevant in YOYO case:
    bool yoyoDescending;
    double yoyoLength;     // in pixels
    double yoyoMaxLength;  // in pixels

};


#endif  /* _H_Enemy */
