#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include "sha1.h"
#include "stralloc.h"
#include "taia.h"

static char qkey[33];
static char *qkey7;
static char *qkey14;
static const char hexcodes[] = "0123456789abcdef";
static unsigned long pid;

char * qconfirm_key(stralloc *b) {
  unsigned char digest[20];
  int i;
  SHA1_CTX sc;
  char buf[TAIA_PACK];
  char ch;
  struct taia t;

  pid =getpid();
  ch =pid; if (! stralloc_append(b, &ch)) return(0);
  ch =(pid >>=8); if (! stralloc_append(b, &ch)) return(0);
  ch =(pid >>=8); if (! stralloc_append(b, &ch)) return(0);
  ch =(pid >>=8); if (! stralloc_append(b, &ch)) return(0);
  taia_now(&t);
  taia_pack(buf, &t);
  if (! stralloc_catb(b, buf, TAIA_PACK)) return(0);

  SHA1_init(&sc);
  SHA1_update(&sc, b->s, b->len);
  SHA1_final(&sc);
  SHA1_digest(&sc, digest);

  /* just take the first 16 bytes... */
  for (i =0; i < 16; ++i) {
    qkey[i * 2] = hexcodes[(digest[i] & 0xf0) >> 4];
    qkey[(i * 2) + 1] = hexcodes[(digest[i] & 0x0f)];
  }
  qkey[i *2] =0;
  return(qkey);
}

char *qconfirm_key7(stralloc *b) {
  qconfirm_key(b);
  while (pid > 25) pid %=25;
  qkey7 =qkey +pid;
  qkey7[7] =0;
  return(qkey7);
}

char *qconfirm_key14(stralloc *b) {
  qconfirm_key(b);
  while (pid > 18) pid %=18;
  qkey14 =qkey +pid;
  qkey14[14] =0;
  return(qkey14);
}
