#include "stralloc.h"
#include "error.h"
#include "byte.h"
#include "open.h"
#include "readclose.h"

static stralloc confs ={0};
static stralloc sa ={0};
static int len =0;

char *conf_get(const char *d, const char *f) {
  int fd;
  char *out ="";

  if (! stralloc_copys(&sa, d)) return(0);
  if (! stralloc_cats(&sa, "/conf/")) return(0);
  if (! stralloc_cats(&sa, f)) return(0);
  if (! stralloc_0(&sa)) return(0);

  confs.len =len;
  if ((fd =open_read(sa.s)) == -1) return(0);
  if (readclose_append(fd, &confs, 128) == -1) return(0);
  if (confs.len > len) {
    confs.len =byte_chr(confs.s +len, confs.len -len, '\n') +len;
    for (fd =len; fd < confs.len; ++fd) if (! confs.s[fd]) confs.s[fd] ='\n';
    if (! stralloc_0(&confs)) return(0);
    out =confs.s +len;
    len =confs.len;
    return(out);
  }
  return(out);
}
char *conf_get_dflt(const char *d, const char *f, char *dflt) {
  char *out;
  
  out =conf_get(d, f);
  if (! out) {
    if (errno != error_noent) return(0);
    out =dflt;
  }
  if (! *out) out =dflt;
  return(out);
}
