#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <time.h>
#include <stdio.h>
#include "qconfirm.h"
#include "qconfirm_conf_get.h"
#include "qconfirm_key.h"
#include "qconfirm_inject.h"
#include "sgetopt.h"
#include "stralloc.h"
#include "env.h"
#include "sig.h"
#include "error.h"
#include "strerr.h"
#include "open.h"
#include "openreadclose.h"
#include "buffer.h"
#include "getline.h"
#include "str.h"
#include "byte.h"
#include "scan.h"
#include "lock.h"
#include "seek.h"

const char *progname;

#define USAGE " [-Av] [-d dir ] [-i bytes ] [-tmda]"
#define VERSION "$Id: qconfirm-notice.c,v 1.9 2004/01/18 14:50:10 pape Exp $"
#define FATAL "qconfirm-notice: fatal: "
#define WARNING "qconfirm-notice: warning: "
#define INFO "qconfirm-notice: info: "

void usage() { strerr_die4x(111, "usage: ", progname, USAGE, "\n"); }
void die_nomem() { strerr_die2x(111, FATAL, "out of memory."); }
void fatal(char *m1, char *m2) { strerr_die4sys(111, FATAL, m1, m2, ": "); }
void warnx(char *m1, char *m2) { strerr_warn3(WARNING, m1, m2, 0); }
void warn(char *m1, char *m2) {
  strerr_warn4(WARNING, m1, m2, ": ", &strerr_sys);
}

char *sender;
char *dflt;
char *local;
char *host;
char *extension;
stralloc qnotice_key ={0};
char *qnotice_ext;
char *qconfirm_dir;
char *qconfirm_prepend;
char *mailname;
char *key;
unsigned long keytimeout =8467200;  /* 14 weeks */
unsigned long size =SIZE;
unsigned int autoconfirm =1;
unsigned int verbose =0;
unsigned int request =0;
unsigned int tmda =0;
unsigned int qsecretary =0;
char *mid =0;
stralloc from ={0};
stralloc reply_to ={0};
unsigned int x_delivery_agent_tmda =0;
unsigned int auto_submitted =0;
unsigned int in_reply_to =0;
unsigned int references =0;
stralloc sa ={0};
stralloc fn ={0};
stralloc tmp ={0};
int lenext;
int lenextkey;
char *s;
unsigned char x;
int fdlock =0;

void new_key(char *old) {
  int fd;

  if (! (key =qconfirm_key7(&sa))) die_nomem();
  if (verbose) strerr_warn3(INFO, "new qnotice_key: ", key, 0);
 
  if (! stralloc_copys(&fn, ".qmail-")) die_nomem();
  if (! stralloc_catb(&fn, extension, lenext)) die_nomem();
  if (! stralloc_catb(&fn, qnotice_key.s, 7)) die_nomem();
  if (! stralloc_cats(&fn, "-default")) die_nomem();
  if (! stralloc_0(&fn)) die_nomem();
  if (openreadclose(fn.s, &tmp, 504) <= 0) fatal("unable to read: ", fn.s);

  if (! stralloc_copys(&sa, ".qmail-")) die_nomem();
  if (! stralloc_catb(&sa, extension, lenext)) die_nomem();
  if (! stralloc_catb(&sa, key, 7)) die_nomem();
  if (! stralloc_cats(&sa, "-default")) die_nomem();
  if (! stralloc_0(&sa)) die_nomem();
  if ((fd =open_trunc(sa.s)) == -1) fatal("unable to create: ", sa.s);
  if (write(fd, tmp.s, tmp.len) != tmp.len) {
    close(fd); unlink(sa.s);
    fatal("unable to write: ", sa.s);
  }
  close(fd);
  if ((fd =open_append(fn.s)) == -1) fatal("unable to open: ", fn.s);
  if (write(fd, "\n# timed out\n", 13) != 13)
    fatal("unable to append: ", fn.s);
  close(fd);
  if (old) {
    if (! stralloc_copys(&sa, ".qmail-")) die_nomem();
    if (! stralloc_catb(&sa, extension, lenext)) die_nomem();
    if (! stralloc_cats(&sa, old)) die_nomem();
    if (! stralloc_cats(&sa, "-default")) die_nomem();
    if (! stralloc_0(&sa)) die_nomem();
    if (verbose) strerr_warn3(INFO, "remove qnotice_key: ", old, 0);
    if (unlink(sa.s) == -1) warn("unable to unlink: ", sa.s);
  }

  if (chdir(qconfirm_dir) == -1)
    fatal("unable to change directory: ", qconfirm_dir);

  if (! stralloc_copys(&tmp, key)) die_nomem();
  if (! stralloc_catb(&tmp, " ", 1)) die_nomem();
  if (! stralloc_cats(&tmp, qnotice_key.s)) die_nomem();
  if (! stralloc_catb(&tmp, "\n", 1)) die_nomem();
  if ((fd =open_trunc(QNOTICEKEY "{tmp}")) == -1)
    fatal("unable to create: ", QNOTICEKEY "{tmp}");
  if (write(fd, tmp.s, tmp.len) != tmp.len) {
    close(fd); unlink(QNOTICEKEY "{tmp}");
    fatal("unable to write: ", QNOTICEKEY "{tmp}");
  }
  close(fd);
  if (rename(QNOTICEKEY "{tmp}", QNOTICEKEY) == -1)
    fatal("unable to rename to: ", QNOTICEKEY);
  if (fdlock) close(fdlock);
}
  
void rotate_key() {
  struct stat st;
  time_t t;
  int i;
  int ld, le;

  ld =str_len(dflt);
  le =str_len(extension);
  if (ld >= le) fatal("bad EXT: ", extension);
  lenextkey =le -ld;
  lenext =byte_rchr(extension, lenextkey -1, '-');
  if (! extension[lenext]) fatal("bad EXT: ", extension);
  ++lenext;

  if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
  if (! stralloc_cats(&sa, "/" QNOTICEKEY)) die_nomem();
  if (! stralloc_0(&sa)) die_nomem();
  if (openreadclose(sa.s, &qnotice_key, 196) <= 0)
    fatal("unable to read: ", sa.s);
  qnotice_key.len =byte_chr(qnotice_key.s, qnotice_key.len, '\n');
  if (qnotice_key.s[qnotice_key.len]) qnotice_key.s[qnotice_key.len] =0;

  i =byte_rchr(qnotice_key.s, qnotice_key.len, ' ');
  if (qnotice_key.s[i] == 0) {
    new_key(0);
    return;
  }
  if (str_len(qnotice_key.s +i +1) != 7)
    strerr_die3x(111, FATAL, "unable to read: " QNOTICEKEY, ": bad format");
  if (! stralloc_copys(&sa, ".qmail-")) die_nomem();
  if (! stralloc_catb(&sa, extension, lenext)) die_nomem();
  if (! stralloc_catb(&sa, qnotice_key.s +i +1, 7)) die_nomem();
  if (! stralloc_cats(&sa, "-default")) die_nomem();
  if (! stralloc_0(&sa)) die_nomem();

  if (stat(sa.s, &st) == -1) {
    warn("remove qnotice_key, unable to stat: ", sa.s);
    qnotice_key.s[i] =0;
    new_key(0);
    return;
  }
  /* setlock */
  if ((fdlock =open_append(sa.s)) == -1) fatal("unable to open: ", sa.s);
  if (lock_ex(fdlock) == -1) fatal("unable to lock: ", sa.s);

  t =time(NULL);
  if ((t > st.st_ctime) && ((t -st.st_ctime) > keytimeout)) {
    qnotice_key.s[i] =0;
    new_key(qnotice_key.s +i +1);
    return;
  }
  close(fdlock);
}
void ok() {
  rotate_key();
  if (verbose) strerr_warn3(INFO, "notification from: ", dflt, 0);
  _exit(0);
}
void bounce() {
  /*  rotate_key(); */
  if (! *sender) /* discard? issue double-bounce for now */
    strerr_die2x(100, "Sorry, no mailbox here by that name: ", dflt);
  strerr_die1x(100, "Sorry, no mailbox here by that name.");
}
void confirm_delivery() {
  buffer b;
  buffer m;
  char b_space[BUFFER_OUTSIZE];
  char m_space[BUFFER_OUTSIZE];
  int fd_msg;
  int fd_inj;
  int c, r;

  if (size) if (seek_begin(0) == -1) fatal("unable to seek: ", "stdin");
  if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
  if (! stralloc_cats(&sa, "/msg/confirm")) die_nomem();
  if (! stralloc_0(&sa)) die_nomem();
  if ((fd_msg =open_read(sa.s)) == -1) fatal("unable to open: ", sa.s);
  if (open_qmail_inject(&fd_inj, 0) == -1) {
    close(fd_msg);
    fatal("unable to inject: ", "delivery confirmation");
  }
  buffer_init(&b, buffer_unixwrite, fd_inj, b_space, sizeof b_space);
  buffer_init(&m, buffer_unixread, fd_msg, m_space, sizeof m_space);

  buffer_puts(&b, "Return-Path: ");
  buffer_puts(&b, local);
  buffer_puts(&b, "@");
  buffer_puts(&b, host);
  buffer_puts(&b, "\nFrom: \"");
  buffer_puts(&b, mailname);
  buffer_puts(&b, "\" <");
  buffer_puts(&b, local);
  buffer_puts(&b, "@");
  buffer_puts(&b, host);
  buffer_puts(&b, ">\nTo: ");
  buffer_puts(&b, reply_to.s);
  buffer_puts(&b, "\n");

  while ((r =buffer_feed(&m)) > 0) {
    buffer_put(&b, buffer_peek(&m), r);
    buffer_seek(&m, r);
  }

  if (size) {
    buffer_puts(&b, "\n");
    buffer_init(&m, buffer_unixread, 0, m_space, sizeof m_space);
    for (c =0; c >= 0; ) {
      if ((r =buffer_feed(&m)) <= 0) break;
      if ((c +=r) > size) {
        r -=(c -size);
        c =-1;
      }
      buffer_put(&b, buffer_peek(&m), r);
      buffer_seek(&m, r);
    }
  }
  buffer_putsflush(&b, "\n");
  close(fd_inj);
  close(fd_msg);
  if (! close_qmail_inject()) {
    warnx("unable to inject: ", "delivery confirmation");
    ok();
  }
}

unsigned int check_mid(stralloc *t, char *m) {
  char *p;
  int l, s;

  m +=str_chr(m, '@');
  if (*m) ++m;
  m[byte_rchr(m, str_len(m), '@')] =0;
  if (! *m) return(0);
  for (p =t->s; (p -t->s) < t->len; ++p) {
    l =str_chr(p, '\n');
    p[l] =0;
    s =str_chr(p, ' ');
    if (p[s] == ' ')
      if (str_equal(m, p +s +1)) return(1);
    p +=l;
  }
  return(0);
}
unsigned int check_request_mid(stralloc *t, char *m) {
  if (! str_start(m, "confirm-")) return(0);
  return(check_mid(t, m +9));
}

int main(int argc, const char **argv) {
  int opt;
  int i;

  progname =*argv;
  umask(0177);
  sig_ignore(sig_pipe);

  qconfirm_dir =env_get("QCONFIRM_DIR");

  while ((opt =getopt(argc, argv, "VvAd:i:t:q:")) != opteof)
    switch(opt) {
    case 'A': autoconfirm =0; break;
    case 'v': verbose =1; break;
    case 'd': qconfirm_dir =(char *)optarg; break;
    case 'i': scan_ulong(optarg, &size); break;
    case 't':
      if (! str_equal(optarg, "mda")) usage();
      tmda =1;
      break;
    case 'q':
      if (! str_equal(optarg, "secretary")) usage();
      qsecretary =1;
      break;
    case 'V': strerr_warn1(VERSION, 0);
    case '?': usage();
    }
  argv +=optind;

  if (! qconfirm_dir) qconfirm_dir =QCONFIRMDIR;
  if ((s =conf_get(qconfirm_dir, "QNOTICE_KEY_TIMEOUT")))
    scan_ulong(s, &keytimeout);
  else
    if (errno != error_noent)
      fatal("unable to read config: ", "QNOTICE_KEY_TIMEOUT");
  sender =env_get("SENDER");
  if (! sender)
    strerr_die2x(100, FATAL, "environment variable SENDER not set.\n");
  dflt =env_get("DEFAULT");
  if (! dflt)
    strerr_die2x(100, FATAL, "environment variable DEFAULT not set.\n");
  if (! *dflt) strerr_die2x(0, INFO, "notification from: (local)");
  local =env_get("LOCAL");
  if (! local)
    strerr_die2x(100, FATAL, "environment variable LOCAL not set.\n");
  host =env_get("HOST");
  if (! host)
    strerr_die2x(100, FATAL, "environment variable HOST not set.\n");
  extension =env_get("EXT");
  if (! extension)
    strerr_die2x(100, FATAL, "environment variable EXT not set.\n");
  qnotice_ext =conf_get_dflt(qconfirm_dir, "QNOTICE_EXT", QNOTICEEXT);
  if (! qnotice_ext)
    fatal("unable to read config: ", "QNOTICE_EXT");
  qconfirm_prepend =conf_get_dflt(qconfirm_dir, "QCONFIRM_PREPEND", "");
  if (! qconfirm_prepend)
    fatal("unable to read config: ", "QCONFIRM_PREPEND");
  mailname =conf_get_dflt(qconfirm_dir, "QCONFIRM_MAILNAME", QCONFIRMMAILNAME);
  if (! mailname)
    fatal("unable to read config: ", "QCONFIRM_MAILNAME");

  i =str_len(qconfirm_prepend);
  if (byte_equal(qconfirm_prepend, i, local)) local +=i;
  for (s =dflt; *s; ++s) {
    x =*s -'A';
    if (x <= 'Z' -'A') *s =x +'a';
    if (*s == '.') *s =':';
  }
  if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
  if (! stralloc_cats(&sa, "/notice/")) die_nomem();
  if (! stralloc_cats(&sa, dflt)) die_nomem();
  if (! stralloc_0(&sa)) die_nomem();

  if (openreadclose(sa.s, &tmp, 504) <= 0) {
    if (errno != error_noent) fatal("unable to open: ", sa.s);
    /* consult virtualdomains */
    if (openreadclose(QMAIL_HOME "/control/virtualdomains", &sa, 504) == -1) {
      if (errno != error_noent)
	fatal("unable to open: ", QMAIL_HOME "/control/virtualdomains");
      bounce();
    }
    for (i =0; i < sa.len; ++i) {
      if (sa.s[i] == ':') {
	opt =str_chr(sa.s +i +1, '\n');
	if (byte_equal(sa.s +i +1, opt, dflt)) {
          if (dflt[opt++] != '-') continue;
	  if (! stralloc_copys(&fn, qconfirm_dir)) die_nomem();
	  if (! stralloc_cats(&fn, "/notice/")) die_nomem();
	  if (! stralloc_cats(&fn, dflt +opt)) die_nomem();
	  if (! stralloc_0(&fn)) die_nomem();
	  if (openreadclose(fn.s, &tmp, 504) <= 0) {
	    if (errno != error_noent)
	      fatal("unable to open: ", fn.s);
	  }
	  else
	    break;
	}
      }
    }
    if (i >= sa.len) {
      /* strerr_warn3(WARNING, "notification unexpected: ", dflt, 0); */
      bounce();
    }
  }

  /* check for confirmation request message */
  while ((i =getline(buffer_0, &sa)) > 0) {
    if ((i == 1) && (sa.s[0] == '\n')) break; /* end of headers */
    if (request && reply_to.s) break;
    for (i =0; i < sa.len; ++i) {
      x =sa.s[i] -'A';
      if (x <= 'Z' -'A') sa.s[i] =x +'a';
    }
    sa.s[sa.len -1] =0;
    if (! request && (sa.len > 12) && str_start(sa.s, "message-id")) {
      for (s =sa.s +10; (*s == ' ') || (*s == '\t'); ++s) ;
      if (*s != ':') continue;
      for (++s; (*s == ' ') || (*s == '\t'); ++s) ;
      if (*s++ != '<') continue;
      mid =s;
      for (; *s && (*s != '>'); ++s) ;
      if (! *s || (s == mid)) mid =0;
      if (mid) {
	*s =0;
	request =check_request_mid(&tmp, mid);
      }
      continue;
    }
    if (! from.s && (sa.len > 6) && str_start(sa.s, "from")) {
      for (s =sa.s +4; (*s == ' ') || (*s == '\t'); ++s) ;
      if (*s != ':') continue;
      for (++s; (*s == ' ') || (*s == '\t'); ++s) ;
      if (! *s) continue;
      if (! stralloc_copys(&from, s)) die_nomem();
      if (! stralloc_0(&from)) die_nomem();
      continue;
    }
    if (! reply_to.s && (sa.len > 10) && str_start(sa.s, "reply-to")) {
      for (s =sa.s +8; (*s == ' ') || (*s == '\t'); ++s) ;
      if (*s != ':') continue;
      for (++s; (*s == ' ') || (*s == '\t'); ++s) ;
      if (! *s) continue;
      if (! stralloc_copys(&reply_to, s)) die_nomem();
      if (! stralloc_0(&reply_to)) die_nomem();
      continue;
    }
    if (tmda) {
      if (! x_delivery_agent_tmda && (sa.len > 23) &&
	  str_start(sa.s, "x-delivery-agent: tmda/")) {
	x_delivery_agent_tmda =1;
	continue;
      }
      if (! auto_submitted && (sa.len >= 28) &&
	  str_start(sa.s, "auto-submitted: auto-replied")) {
	auto_submitted =1;  /* XXX */
	continue;
      }
      if (! in_reply_to && (sa.len > 13) && str_start(sa.s, "in-reply-to")) {
	for (s =sa.s +11; (*s == ' ') || (*s == '\t'); ++s) ;
	if (*s != ':') continue;
	for (++s; (*s == ' ') || (*s == '\t'); ++s) ;
	if (*s++ != '<') continue;
	mid =s;
	for (; *s && (*s != '>'); ++s) ;
	if (! *s || (s == mid)) mid =0;
	if (mid) {
	  *s =0;
	  in_reply_to =check_mid(&tmp, mid);
	}
	continue;
      }
      if (! references && (sa.len > 12) && str_start(sa.s, "references")) {
	for (s =sa.s +10; (*s == ' ') || (*s == '\t'); ++s) ;
	if (*s != ':') continue;
	for (++s; (*s == ' ') || (*s == '\t'); ++s) ;
	if (*s++ != '<') continue;
	mid =s;
	for (; *s && (*s != '>'); ++s) ;
	if (! *s || (s == mid)) mid =0;
	if (mid) {
	  *s =0;
	  references =check_mid(&tmp, mid);
	}
	continue;
      }
    }
  }
  if (request) {
    if (! reply_to.s)
      if (from.s)
	if (! stralloc_copyb(&reply_to, from.s, from.len)) die_nomem();
    if (! reply_to.s) {
      warnx("confirmation request without address to reply to: ", dflt);
      ok();
    }
    if (autoconfirm) {
      confirm_delivery();
      warnx("sending delivery confirmation: ", dflt);
      _exit(99);
    }
    else
      warnx("not automatically sending delivery confirmation: ", dflt);
    ok();
  }
  if (tmda) {
    int equal, at;
    if ((in_reply_to || references) && x_delivery_agent_tmda &&
	auto_submitted && reply_to.s) {
      for (s =reply_to.s; *s; ++s) {
	x =*s -'A';
	if (x <= 'Z' -'A') *s =x +'a';
      }
      for (s =dflt; *s; ++s) if (*s == ':') *s ='.';
      equal =byte_rchr(dflt, str_len(dflt), '=');
      opt =str_chr(reply_to.s, '<');
      if (reply_to.s[opt++] != '<') opt =0;
      at =byte_rchr(reply_to.s +opt, reply_to.len -opt, '@') +opt;
      if (dflt[equal] && reply_to.s[at] && (at -opt > equal))
	if (str_start(reply_to.s +at +1, dflt +equal +1))
	  if (byte_equal(reply_to.s +opt, equal, dflt)) {
	    if (autoconfirm) {
	      confirm_delivery();
	      warnx("sending delivery confirmation (tmda): ", dflt);
	      _exit(99);
	    }
	    else
	      warnx("not automatically sending delivery confirmation (tmda): ",
		    dflt);
	    ok();
	  }
    }
  }
  ok();
  return(0);
}
