#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include "qconfirm.h"
#include "qconfirm_conf_get.h"
#include "qconfirm_key.h"
#include "sgetopt.h"
#include "strerr.h"
#include "env.h"
#include "error.h"
#include "stralloc.h"
#include "pathexec.h"
#include "byte.h"
#include "str.h"
#include "scan.h"
#include "open.h"
#include "openreadclose.h"
#include "fmt.h"
#include "lock.h"

#define USAGE " [-v] [-t sec ] [-nN] recip ..."
#define VERSION "$Id: qconfirm-inject.c,v 1.16 2004/08/23 20:58:40 pape Exp $"
#define FATAL "qconfirm-inject: fatal: "
#define WARNING "qconfirm-inject: warning: "
#define INFO "qconfirm-inject: info: "

#define QNOTICEQMAILINJECT QMAIL_HOME "/bin/qmail-inject"

const char *progname;

void usage() { strerr_die4x(100, "usage: ", progname, USAGE, "\n"); }
void die_nomem() { strerr_die2x(111, FATAL, "out of memory."); }
void fatal(char *m1, char *m2) { strerr_die4sys(111, FATAL, m1, m2, ": "); }
void warn_unlink(char *fn) {
  strerr_warn4(WARNING, "unable to unlink: ", fn, ": ", &strerr_sys);
}

char *suser;
char *shost;
stralloc qnotice_key ={0};
stralloc qconfirm_dir ={0};
char *key;
char *qnotice_ext;
char *qconfirm_prepend;
char *qconfirm_mid;
char *qmail_inject;
char *home;
char *s;

unsigned long timeout =3628800;  /* 42 days */
unsigned int verbose =0;
char *optn =0;
stralloc ids ={0};
stralloc sa ={0};
stralloc tmp ={0};
const char **recip;
char numbuf[FMT_ULONG];
int fd;
int fdlock;
time_t now;
unsigned long t;

int main(int argc, const char **argv) {
  int opt;
  int i, j;
  unsigned char x;
  int base;

  progname =*argv;

  home =env_get("HOME");
  if (! home)
    strerr_die2x(100, FATAL, "environment variable HOME not set.");
  if ((s =env_get("QCONFIRM_DIR")))
    if (! stralloc_copys(&qconfirm_dir, s)) die_nomem();
  if (! qconfirm_dir.s) {
    if (! stralloc_copys(&qconfirm_dir, home)) die_nomem();
    if (! stralloc_cats(&qconfirm_dir, "/" QCONFIRMDIR)) die_nomem();
  }
  if (! stralloc_0(&qconfirm_dir)) die_nomem();
  if ((s =conf_get(qconfirm_dir.s, "QCONFIRM_MID_TIMEOUT")))
    scan_ulong(s, &timeout);
  else
    if (errno != error_noent)
      fatal("unable to read config: ", "QCONFIRM_MID_TIMEOUT");

  while ((opt =getopt(argc, argv, "VvNnt:")) != opteof) {
    switch(opt) {
    case 'v': verbose =1; break;
    case 'n': optn ="-n"; break;
    case 'N': optn ="-N"; break;
    case 't': scan_ulong(optarg, &timeout); break;
    case 'V': strerr_warn1(VERSION, 0);
    case '?': usage();
    }
  }
  argv +=optind;
  if (! argv || ! *argv) usage();
  recip =argv;
  for (; *recip; ++recip) {
    j =byte_rchr(*recip, str_len(*recip), '@');
    if ((*recip)[j] == 0) usage();
    j +=byte_rchr(*recip +j, str_len(*recip +j), '.');
    if (((*recip)[j] == 0) || ((*recip)[j +1] == 0)) usage();
  }
  recip =argv;

  suser =conf_get(qconfirm_dir.s, "QNOTICE_USER");
  if (! suser)
    if (errno != error_noent) fatal("unable to read config: ", "QNOTICE_USER");
  if (! suser) suser =env_get("USER");
  if (! suser) suser =env_get("LOGNAME");
  if (! suser)
    strerr_die2x(100, FATAL, "environment variable USER and LOGNAME not set.");
  shost =conf_get(qconfirm_dir.s, "QNOTICE_HOST");
  if (! shost)
    if (errno != error_noent) fatal("unable to read config: ", "QNOTICE_HOST");

  qnotice_ext =conf_get_dflt(qconfirm_dir.s, "QNOTICE_EXT", QNOTICEEXT);
  if (! qnotice_ext) fatal("unable to read config: ", "QNOTICE_EXT");
  qmail_inject =conf_get_dflt(qconfirm_dir.s,
			      "QNOTICE_QMAIL_INJECT", QNOTICEQMAILINJECT);
  if (! qmail_inject) fatal("unable to read config: ", "QNOTICE_QMAIL_INJECT");
  qconfirm_mid =conf_get(qconfirm_dir.s, "QCONFIRM_MID");
  if (! qconfirm_mid) fatal("unable to read config: ", "QCONFIRM_MID");
  if (! *qconfirm_mid) strerr_die2x(100, FATAL, "QCONFIRM_MID is empty.");
  qconfirm_prepend =conf_get_dflt(qconfirm_dir.s, "QCONFIRM_PREPEND", "");
  if (! qconfirm_prepend) fatal("unable to read config: ", "QCONFIRM_PREPEND");

  if (! stralloc_copys(&sa, qconfirm_dir.s)) die_nomem();
  if (! stralloc_cats(&sa, "/" QNOTICEKEY)) die_nomem();
  if (! stralloc_0(&sa)) die_nomem();
  if (openreadclose(sa.s, &qnotice_key, 196) <= 0)
    fatal("unable to read: ", sa.s);
  qnotice_key.len =byte_chr(qnotice_key.s, qnotice_key.len, '\n');
  if (! stralloc_0(&qnotice_key)) die_nomem();

  qnotice_key.len =byte_chr(qnotice_key.s, qnotice_key.len -1, ' ');
  if (! qnotice_key.len || ! *qnotice_key.s)
    strerr_die2x(100, FATAL, "bad QNOTICE_KEY.");

  if (! stralloc_copys(&sa, home)) die_nomem();
  if (! stralloc_cats(&sa, "/.qmail-")) die_nomem();
  i =sa.len;
  if (*qconfirm_prepend) {
    if (! str_start(qconfirm_prepend, suser))
      strerr_die2x(100, FATAL, "QNOTICE_USER doesn't match QCONFIRM_PREPEND");
    qconfirm_prepend +=str_len(suser);
    if (*qconfirm_prepend != '-')
      strerr_die2x(100, FATAL, "QNOTICE_USER doesn't match QCONFIRM_PREPEND");
    if (! stralloc_cats(&sa, ++qconfirm_prepend)) die_nomem();
    if (! stralloc_cats(&sa, suser)) die_nomem();
    if (! stralloc_append(&sa, "-")) die_nomem();
  }
  if (! stralloc_cats(&sa, qnotice_ext)) die_nomem();
  if (! stralloc_catb(&sa, qnotice_key.s, qnotice_key.len)) die_nomem();
  if (! stralloc_cats(&sa, "-default")) die_nomem();
  if (! stralloc_0(&sa)) die_nomem();
  for (s =sa.s +i; *s; ++s) {
    x =*s -'A';
    if (x <= 'Z' -'A') *s =x +'a';
    if (*s == '.') *s =':';
  }
  if ((fd =open_write(sa.s)) == -1) {
    if (errno == error_noent)
      strerr_die3x(111, FATAL, "notification handler does not exist: ", sa.s);
    fatal("unable to open: ", sa.s);
  }
  close(fd);

  if (! stralloc_copys(&sa, suser)) die_nomem();
  if (! stralloc_cats(&sa, "-")) die_nomem();
  if (! stralloc_cats(&sa, qnotice_ext)) die_nomem();
  if (! stralloc_catb(&sa, qnotice_key.s, qnotice_key.len)) die_nomem();
  if (! stralloc_0(&sa)) die_nomem();
  if (! pathexec_env("QMAILSUSER", sa.s)) die_nomem();
  if (shost)
    if (! pathexec_env("QMAILSHOST", shost)) die_nomem();

  key =qconfirm_key14(&qnotice_key);
  qconfirm_mid[byte_chr(qconfirm_mid, str_len(qconfirm_mid), ' ')] =0;
  if (! *qconfirm_mid) strerr_die2x(100, FATAL, "bad QCONFIRM_MID.");
  if (! stralloc_copyb(&sa, key, 14)) die_nomem();
  if (! stralloc_catb(&sa, ".", 1)) die_nomem();
  if (! stralloc_cats(&sa, qconfirm_mid)) die_nomem();
  if (! stralloc_0(&sa)) die_nomem();
  if (! pathexec_env("QMAILIDHOST", sa.s)) die_nomem();
  
  /* create notice/id */
  if (! stralloc_copys(&sa, qconfirm_dir.s)) die_nomem();
  if (! stralloc_cats(&sa, "/notice/")) die_nomem();
  base =sa.len;
  for (now =time(NULL); *recip; ++recip, sa.len =base) {
    i =byte_rchr(*recip, str_len(*recip), '@');
    if (! (*recip)[i]) usage();
    if (! stralloc_catb(&sa, *recip, i)) die_nomem();
    if (! stralloc_catb(&sa, "=", 1)) die_nomem();
    if (! stralloc_cats(&sa, *recip +i +1)) die_nomem();
    if (! stralloc_0(&sa)) die_nomem();
    for (s =sa.s +base; *s; ++s) {
      x =*s -'A';
      if (x <= 'Z' -'A') *s =x +'a';
      if (*s == '.') *s =':';
    }
    /* setlock */
    if ((fdlock =open_append(sa.s)) == -1) fatal("unable to open: ", sa.s);
    if (lock_ex(fdlock) == -1) fatal("unable to lock: ", sa.s);
    j =0;
    if (openreadclose(sa.s, &ids, 504) > 0) {
      for (; j < ids.len; ++j) {
	if (ids.s[scan_ulong(ids.s +j, &t) +j] != ' ') {
	  i =str_chr(ids.s +j, '\n');
	  ids.s[i +j] =0;
	  strerr_warn6(WARNING, "remove entry: ", sa.s, ": ", ids.s +j,
		       ": bad format", 0);
	  j +=i;
	  continue;
	}
	if ((now > t) && ((now -t) > timeout)) {
	  i =str_chr(ids.s +j, '\n');
	  ids.s[i +j] =0;
	  if (verbose)
	    strerr_warn6(INFO, "remove entry: ", sa.s, ": ", ids.s +j,
			 ": timed out", 0);
	  j +=i;
	  continue;
	  }
	break;
      }
      if ((j < ids.len) && (ids.s[ids.len -1] != '\n'))
	if (! stralloc_cats(&ids, "\n")) die_nomem();
    }
    numbuf[fmt_ulong(numbuf, now)] =0;
    if (! stralloc_cats(&ids, numbuf)) die_nomem();
    if (! stralloc_catb(&ids, " ", 1)) die_nomem();
    if (! stralloc_catb(&ids, key, 14)) die_nomem();
    if (! stralloc_catb(&ids, ".", 1)) die_nomem();
    if (! stralloc_cats(&ids, qconfirm_mid)) die_nomem();
    if (! stralloc_catb(&ids, "\n", 1)) die_nomem();
    
    if (! stralloc_copys(&tmp, sa.s)) die_nomem();
    if (! stralloc_cats(&tmp, ".{tmp}")) die_nomem();
    if (! stralloc_0(&tmp)) die_nomem();
    if ((fd =open_trunc(tmp.s)) == -1) fatal("unable to create: ", tmp.s);
    if (s && (write(fd, ids.s +j, ids.len -j) != (ids.len -j))) {
      close(fd);
      if (unlink(tmp.s) == -1) warn_unlink(tmp.s);
      fatal("unable to write: ", tmp.s);
    }
    close(fd);
    if (rename(tmp.s, sa.s) == -1)
      strerr_die6sys(111, FATAL,
		     "unable to rename ", tmp.s, " to : ", sa.s, ": ");
    close(fdlock);
  }

  /* qmail-inject */
  if (! pathexec_env("QMAILINJECT", "sir")) die_nomem();
  if (optn) *--argv =optn;
  *--argv =qmail_inject;
  pathexec(argv);
  fatal("unable to run: ", qmail_inject);
  return(0);
}
