#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <time.h>
#include "qconfirm.h"
#include "qconfirm_conf_get.h"
#include "qconfirm_inject.h"
#include "qconfirm_key.h"
#include "qconfirm_id.h"
#include "env.h"
#include "stralloc.h"
#include "strerr.h"
#include "str.h"
#include "error.h"
#include "buffer.h"
#include "fmt.h"
#include "sgetopt.h"
#include "open.h"
#include "scan.h"
#include "openreadclose.h"
#include "byte.h"
#include "pathexec.h"
#include "wait.h"
#include "sig.h"
#include "lock.h"
#include "getline.h"
#include "seek.h"

#define USAGE " [-mnbD] [-d dir ] [-i bytes ] [-t sec ] [prog]"
#define VERSION "$Id: qconfirm-check.c,v 1.55 2004/12/12 16:52:22 pape Exp $"
#define FATAL "qconfirm-check: fatal: "
#define WARNING "qconfirm-check: warning: "
#define INFO "qconfirm-check: info: "
#define EXTRA "qconfirm-check: extra: "

#define MODE_SENDER 0
#define MODE_INODE 1

const char *progname;

void usage() { strerr_die4x(111, "usage: ", progname, USAGE, "\n"); }
void die_nomem() { strerr_die2x(111, FATAL, "out of memory."); }
void warn_unlink(char *fn) {
  strerr_warn4(WARNING, "unable to unlink: ", fn, ": ", &strerr_sys);
}
void fatal(char *m0, char *m1) { strerr_die4sys(111, FATAL, m0, m1, ": "); }
void fatalx(char *m0, char *m1, char *m2) {
  strerr_die4x(111, FATAL, m0, m1, m2);
}
void warn(char *m0, char *m1) {
  strerr_warn4(WARNING, m0, m1, ": ", &strerr_sys);
}
void ok(char *m) { strerr_die3x(0, INFO, "ok: ", m); }
void defer(char *m) { strerr_die3x(111, INFO, "defer: ", m); }

stralloc id ={0};
stralloc fn ={0};
stralloc fn_ok ={0};
stralloc fn_pending ={0};
stralloc fn_confirm ={0};
stralloc msg ={0};
stralloc command ={0};
stralloc hostsa ={0};
stralloc sa ={0};
stralloc k ={0};
char *sender;
char *local;
char *host;
char *ext;
char *qconfirm_ext;
char *qconfirm_prepend;
char *qconfirm_dir;
char *mailname;
char *qconfirm_accept;
char *qconfirm_accept_prog;
char *mid;
int mode =MODE_SENDER;
unsigned long timeout =TIMEOUT;
unsigned long size =SIZE;
int ack =1;
int wildhost =1;
int badmailfrom =0;
struct stat msg_st;
int fdmsg;

int inject_qconfirm_msg (int fd_msg, char *extension, char *mid, int fd) {
  buffer b;
  buffer m;
  char b_space[BUFFER_OUTSIZE];
  char m_space[BUFFER_OUTSIZE];
  int fd_inj;
  int r;
  int c;
  
  if (open_qmail_inject(&fd_inj, sender) == -1) {close(fd_msg); return(-1); }
  buffer_init(&b, buffer_unixwrite, fd_inj, b_space, sizeof b_space);
  buffer_init(&m, buffer_unixread, fd_msg, m_space, sizeof m_space);

  if (mid && *mid) {
    buffer_puts(&b, "Message-ID: <confirm-");
    buffer_puts(&b, mid);
    buffer_puts(&b, "@");
    buffer_puts(&b, host);
    buffer_puts(&b, ">\n");
  }
  buffer_puts(&b, "From: \"");
  buffer_puts(&b, mailname);
  buffer_puts(&b, "\" <");
  buffer_puts(&b, local);
  if (extension) {
    buffer_puts(&b, "-");
    buffer_puts(&b, qconfirm_ext);
    buffer_puts(&b, extension);
  }
  buffer_puts(&b, "@");
  buffer_puts(&b, host);
  buffer_puts(&b, ">\nTo: ");
  buffer_puts(&b, sender);
  buffer_puts(&b, "\n");

  while ((r =buffer_feed(&m)) > 0) {
    buffer_put(&b, buffer_peek(&m), r);
    buffer_seek(&m, r);
  }

  if (size > 0) {
    buffer_puts(&b, "\n");
    if (fd != -1) {
      buffer_init(&m, buffer_unixread, fd, m_space, sizeof m_space);
      for (c =0; c >= 0; ) {
	if ((r =buffer_feed(&m)) <= 0) break;
	if ((c +=r) > size) {
	  r -=(c -size);
	  c =-1;
	}
	buffer_put(&b, buffer_peek(&m), r);
	buffer_seek(&m, r);
      }
    }
    else
      buffer_puts(&b, "Delivery has been confirmed manually.");
  }
  buffer_putsflush(&b, "\n");
  close(fd_inj);
  close(fd_msg);
  if (! close_qmail_inject()) return(-1);
  return(1);
}

int queuelifetime_expired() {
  unsigned long t =604800;
  time_t now;

  if (openreadclose(QMAIL_HOME "/control/queuelifetime", &sa, FMT_ULONG)) {
    if (! stralloc_0(&sa)) die_nomem();
    scan_ulong(sa.s, &t);
  }
  now =time(NULL);
  if ((now -msg_st.st_mtime) >= t) return(1);
  return(0);
}

int pending_remove (stralloc *id) {
  unsigned long ino;
  int r;
  char *s;

  if (! stralloc_copys(&fn, qconfirm_dir)) die_nomem();
  if (! stralloc_cats(&fn, "/pending/")) die_nomem();
  if (! stralloc_cat(&fn, id)) die_nomem();

  /* read the key */
  if ((r =openreadclose(fn.s, &k, 74)) == -1) fatal("unable to read: ", fn.s);
  if (r == 0) /* error_noent */
    return(0);
  if (k.len < 34)
    fatalx("unable to read: ", fn.s, ": bad format");
  if (! stralloc_0(&k)) die_nomem();
  if (k.s[32] != ' ') fatalx("unable to read: ", fn.s, ": bad format");
  s =k.s +33;
  if ((s +=scan_ulong(s, &ino)) == (k.s +33))
    fatalx("unable to read: ", fn.s, ": bad inode");
  if (ino != msg_st.st_ino) /* another message from same sender id */
    return(-1);
  if (*s) { /* backward compatibility 0.9.3 */
    if (*s != ' ') fatalx("unable to read: ", fn.s, ": bad format");
    if (str_diff(s +1, ext) != 0) /* another message from same sender id */
      return(-1);
  }
  k.s[32] =0;
  if (! stralloc_copys(&sa, ".qmail-")) die_nomem();
  if (str_len(ext) != 0) {
    if (! stralloc_cats(&sa, ext)) die_nomem();
    if (! stralloc_cats(&sa, "-")) die_nomem();
  }
  if (! stralloc_cats(&sa, qconfirm_ext)) die_nomem();
  if (! stralloc_cats(&sa, k.s)) die_nomem();
  if (! stralloc_0(&sa)) die_nomem();
  if (unlink(sa.s) == -1) warn_unlink(sa.s);
  if (unlink(fn.s) == -1) warn_unlink(fn.s);

  /* bounces */
  if (! stralloc_copys(&fn, qconfirm_dir)) die_nomem();
  if (! stralloc_cats(&fn, "/return/")) die_nomem();
  if (! stralloc_cat(&fn, id)) die_nomem();
  unlink(fn.s); /* don't care if this fails */
  return(1);
}

unsigned int sneak_preview() {
  char *qcontrol_owner;
  buffer b;
  char b_space[BUFFER_OUTSIZE];
  int fd_inj;
  int r;

  if (! (qcontrol_owner =conf_get(qconfirm_dir, "QCONTROL_OWNER"))) {
    strerr_warn2(WARNING, "unable to read config: QCONTROL_OWNER",
      &strerr_sys);
    return(0);
  }
  if (! *qcontrol_owner) {
    strerr_warn2(WARNING, "QCONTROL_OWNER is empty", 0);
    return(0);
  }
  if (open_qmail_inject(&fd_inj, qcontrol_owner) == -1) return(0);
  buffer_init(&b, buffer_unixwrite, fd_inj, b_space, sizeof b_space);

  buffer_puts(&b, "Return-Path: <>\nFrom: \"");
  buffer_puts(&b, mailname);
  buffer_puts(&b, "\" <");
  buffer_puts(&b, qcontrol_owner);
  buffer_puts(&b, ">\nTo: ");
  buffer_puts(&b, qcontrol_owner);
  buffer_puts(&b, "\nSubject: qconfirm sneak preview\n\nReturn-Path: <");
  buffer_puts(&b, sender);
  buffer_puts(&b, ">\n");
  while ((r =buffer_feed(buffer_0)) > 0) {
    buffer_put(&b, buffer_peek(buffer_0), r);
    buffer_seek(buffer_0, r);
  }
  buffer_flush(&b);
  close(fd_inj);
  if (close_qmail_inject() == -1) return(0);
  return(1);
}

int main(int argc, const char **argv) {
  char *key;
  char *s;
  unsigned char x;
  int fd, i;
  struct stat st;
  time_t now;
  int opt;
  const char **prog;
  char inode[FMT_ULONG];

  progname =*argv;
  umask(0177);
  sig_ignore(sig_pipe);

  qconfirm_dir =env_get("QCONFIRM_DIR");

  while ((opt =getopt(argc, argv, "Vmnbd:Di:t:")) != opteof) {
    switch(opt) {
    case 'm': mode =MODE_INODE; break;
    case 'n': ack =0; break;
    case 'b': badmailfrom =1; break;
    case 'D': wildhost =0; break;
    case 'd': qconfirm_dir =(char *)optarg; break;
    case 'i': scan_ulong(optarg, &size); break;
    case 't': scan_ulong(optarg, &timeout); break;
    case 'V': strerr_warn1(VERSION, 0);
    case '?': usage();
    }
  }
  argv +=optind;
  prog =0;
  if (argv && *argv) prog =argv;

  sender =env_get("SENDER");
  if (! sender)
    strerr_die2x(100, FATAL, "environment variable SENDER not set.\n");
  if (! *sender) ok("empty sender");
  if (str_equal(sender, "#@[]")) ok("double bounce");
  local =env_get("LOCAL");
  if (! local)
    strerr_die2x(100, FATAL, "environment variable LOCAL not set.\n");
  host =env_get("HOST");
  if (! host)
    strerr_die2x(100, FATAL, "environment variable HOST not set.\n");
  ext =env_get("EXT");
  if (! ext)
    strerr_die2x(100, FATAL, "environment variable EXT not set.\n");

  if (! qconfirm_dir) qconfirm_dir =QCONFIRMDIR;
  if ((s =conf_get(qconfirm_dir, "QCONFIRM_HOST")))
    host =s;
  else if (errno != error_noent)
    fatal("unable to read config: ", "QCONFIRM_HOST");
  qconfirm_ext =conf_get_dflt(qconfirm_dir, "QCONFIRM_EXT", QCONFIRMEXT);
  if (! qconfirm_ext)
    fatal("unable to read config: ", "QCONFIRM_EXT");
  qconfirm_prepend =conf_get_dflt(qconfirm_dir, "QCONFIRM_PREPEND", "");
  if (! qconfirm_prepend)
    fatal("unable to read config: ", "QCONFIRM_PREPEND");
  mailname =conf_get_dflt(qconfirm_dir, "QCONFIRM_MAILNAME", QCONFIRMMAILNAME);
  if (! mailname)
    fatal("unable to read config: ", "QCONFIRM_MAILNAME");
  qconfirm_accept =conf_get_dflt(qconfirm_dir,
				 "QCONFIRM_ACCEPT", "qconfirm-accept");
  if (! qconfirm_accept)
    fatal("unable to read config: ", "QCONFIRM_ACCEPT");
  qconfirm_accept_prog =conf_get_dflt(qconfirm_dir,
				      "QCONFIRM_ACCEPT_PROG", "");
  if (! qconfirm_accept_prog)
    fatal("unable to read config: ", "QCONFIRM_ACCEPT_PROG");

  if (fstat(0, &msg_st) == -1) fatal("unable to fstat(): ", "stdin");
  inode[fmt_ulong(inode, msg_st.st_ino)] = 0;
  if (! inode[0] || (inode[0] == '0'))
    strerr_die2sys(111, FATAL, "bad message inode.");
  
  i =str_len(qconfirm_prepend);
  if (byte_equal(qconfirm_prepend, i, local)) local +=i;

  /* lowercase ext, replace dot with colon */
  for (s =ext; *s; ++s) {
    x =*s -'A';
    if (x <= 'Z' -'A') *s =x +'a';
    if (*s == '.') *s =':';
  }

  /* create id */
  if (mode == MODE_SENDER) {
    /* setlock */
    if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
    if (! stralloc_cats(&sa, "/.lock")) die_nomem();
    if (! stralloc_0(&sa)) die_nomem();
    if ((fd =open_append(sa.s)) == -1) fatal("unable to open: ", sa.s);
    if (lock_ex(fd) == -1) fatal("unable to lock: ", sa.s);
    if (address2id(&id, sender) == -1) die_nomem();
  }
  else {
    /* MODE_INODE */
    if (! stralloc_copys(&id, inode)) die_nomem();
    if (! stralloc_0(&id)) die_nomem();
  }

  /* check ok/ */
  if (! stralloc_copys(&fn_ok, qconfirm_dir)) die_nomem();
  if (! stralloc_cats(&fn_ok, "/ok/")) die_nomem();
  if (! stralloc_cat(&fn_ok, &id)) die_nomem();
  if (stat(fn_ok.s, &st) != -1) {
    /* message is accepted */
    if ((st.st_size > 0) && ack) {
      /* inject confirmation ack */
      if ((fd =open_read(fn_ok.s)) == -1) fatal("unable to open: ", fn_ok.s);
      if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
      if (! stralloc_cats(&sa, "/msg/acknowledge")) die_nomem();
      if (! stralloc_0(&sa)) die_nomem();
      if ((fdmsg =open_read(sa.s)) == -1) fatal("unable to open: ", sa.s);
      inject_qconfirm_msg(fdmsg, 0, 0, fd);
      close(fd);
    }
    /* ok */
    if (mode == MODE_SENDER) {
      if ((fd =open_trunc(fn_ok.s)) == -1) warn("unable to trunc: ", fn_ok.s);
      close(fd);
    }
    if (mode == MODE_INODE)
      if (unlink(fn_ok.s) == -1) warn_unlink(fn_ok.s);
    ok(fn_ok.s);
  }
  if (errno != error_noent) fatal("unable to stat: ", fn_ok.s);
  
  if (mode == MODE_SENDER) {
    /* check -default */
    for (i =id.len; i >= 0; --i) {
      if (! i || (id.s[i -1] == '-')) {
	if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
	if (! stralloc_cats(&sa, "/ok/")) die_nomem();
	if (! stralloc_catb(&sa, id.s, i)) die_nomem();
	if (! stralloc_cats(&sa, "default")) die_nomem();
	if (! stralloc_0(&sa)) die_nomem();
	if ((fd =open_read(sa.s)) != -1) {
	  close(fd);
	  /* ok */
	  if ((fd =open_trunc(sa.s)) == -1) warn("unable to trunc: ", sa.s);
	  close(fd);
	  if ((pending_remove(&id) == 1) && ack) {
	    if (! stralloc_copys(&msg, qconfirm_dir)) die_nomem();
	    if (! stralloc_cats(&msg, "/msg/acknowledge")) die_nomem();
	    if (! stralloc_0(&msg)) die_nomem();
            if ((fdmsg =open_read(msg.s)) == -1)
	      fatal("unable to open: ", msg.s);
	    inject_qconfirm_msg(fdmsg, 0, 0, -1);
	    close(fd);
	  }
	  ok(sa.s);
	}
	if (errno != error_noent) fatal("unable to open: ", sa.s);
      }
    }
    /* check host: a:b:c:d, :b:c:d, :c:d, :d. */
    if (wildhost && ((i =byte_chr(id.s, id.len, '=')) != id.len)) {
      if (! stralloc_copyb(&hostsa, id.s, i)) die_nomem();
      for (i =0; i < hostsa.len; ++i) {
	if ((hostsa.s[i] == ':') || ! i) {
	  if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
	  if (! stralloc_cats(&sa, "/ok/")) die_nomem();
	  if (! stralloc_catb(&sa, hostsa.s +i, hostsa.len -i)) die_nomem();
	  if (! stralloc_0(&sa)) die_nomem();
	  if ((fd =open_read(sa.s)) != -1) {
	    close(fd);
	    /* ok */
	    if ((fd =open_trunc(sa.s)) == -1) warn("unable to trunc: ", sa.s);
	    close(fd);
	    if ((pending_remove(&id) == 1) && ack) {
	      if (! stralloc_copys(&msg, qconfirm_dir)) die_nomem();
	      if (! stralloc_cats(&msg, "/msg/acknowledge")) die_nomem();
	      if (! stralloc_0(&msg)) die_nomem();
              if ((fdmsg =open_read(msg.s)) == -1)
		fatal("unable to open: ", msg.s);
	      inject_qconfirm_msg(fdmsg, 0, 0, -1);
	      close(fd);
	    }
	    ok(sa.s);
	  }
	  if (errno != error_noent) fatal("unable to stat: ", sa.s);
	}
      }
    }
  }

  if (! stralloc_copys(&msg, qconfirm_dir)) die_nomem();
  if (! stralloc_cats(&msg, "/msg/request")) die_nomem();
  if (! stralloc_0(&msg)) die_nomem();

  /* check pending/ */
  if (! stralloc_copys(&fn_pending, qconfirm_dir)) die_nomem();
  if (! stralloc_cats(&fn_pending, "/pending/")) die_nomem();
  if (! stralloc_cat(&fn_pending, &id)) die_nomem();
  if (stat(fn_pending.s, &st) != -1) {
    if ((st.st_mode & S_IRWXU) == S_IWUSR) { /* bounce */
      if (chmod(fn_pending.s, 0600) == -1)
	fatal("unable to chmod: ", fn_pending.s);
      if (pending_remove(&id) == -1) {
	if (chmod(fn_pending.s, st.st_mode) == -1)
	  warn("unable to chmod: ", fn_pending.s);
	strerr_die1x(100, "No delivery confirmation received, abort (extra).");
      }
      strerr_die1x(100, "No delivery confirmation received, abort.");
    }
    if ((st.st_mode & S_IRWXU) == 0) { /* drop */
      if (chmod(fn_pending.s, 0600) == -1)
	fatal("unable to chmod: ", fn_pending.s);
      if (pending_remove(&id) == -1) {
	if (chmod(fn_pending.s, st.st_mode) == -1)
	  warn("unable to chmod: ", fn_pending.s);
	strerr_die3x(99, EXTRA, "drop: ", fn_pending.s);
      }
      strerr_die3x(99, INFO, "drop: ", fn_pending.s);
    }
    if ((st.st_mode & S_IRWXU) == S_IRWXU) { /* accept */
      if (pending_remove(&id) == -1) /* additional message */
	strerr_die3x(0, EXTRA,
		   "Delivery has been confirmed manually: ", fn_pending.s);
      if ((fd =open_trunc(fn_ok.s)) == -1) fatal("unable to open: ", fn_ok.s);
      close(fd);
      if (ack) {
	/* inject confirmation ack */
	if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
	if (! stralloc_cats(&sa, "/msg/acknowledge")) die_nomem();
	if (! stralloc_0(&sa)) die_nomem();
        if ((fdmsg =open_read(sa.s)) == -1) fatal("unable to open: ", sa.s);
	inject_qconfirm_msg(fdmsg, 0, 0, -1);
      }
      strerr_die3x(0, INFO,
		   "Delivery has been confirmed manually: ", fn_ok.s);
    }
    if ((st.st_mode & S_IRWXU) == S_IRUSR) { /* sneak */
      if (sneak_preview())
	if (chmod(fn_pending.s, 0600) == -1)
	  fatal("unable to chmod: ", fn_pending.s);
    }

    /* check queuelifetime */
    if (queuelifetime_expired()) {
      if (pending_remove(&id) == -1)
	strerr_die1x(100, "No delivery confirmation received (extra).");
      strerr_die1x(100, "No delivery confirmation received.");
    }
    if (timeout > 0) {
      /* check pending timeout */
      if (stat(fn_pending.s, &st) == -1)
	fatal("unable to stat: ", fn_pending.s);
      now =time(NULL);
      if ((now -st.st_mtime) >= timeout) {
	unsigned long ino;

	/* read key and inode */
	if (openreadclose(fn_pending.s, &k, 74) != 1)
	  fatal("unable to read: ", fn_pending.s);
	if (k.len < 34)
	  fatalx("unable to read: ", fn_pending.s, ": bad format");
	if (! stralloc_0(&k)) die_nomem();
	if (k.s[32] != ' ')
	  fatalx("unable to read: ", fn_pending.s, ": bad format");
	s =k.s +33;
	if ((s +=scan_ulong(s, &ino)) == (k.s +33))
	  fatalx("unable to read: ", fn_pending.s, ": bad inode");
	if (ino != msg_st.st_ino) /* another message from same sender id */
	  strerr_die3x(111, EXTRA, "defer: ", fn_pending.s);
	if (*s) { /* backward compatibility 0.9.3 */
	  if (*s != ' ')
	    fatalx("unable to read: ", fn_pending.s, ": bad format");
	  if (str_diff(s +1, ext) != 0) /* another message same sender id */
	    return(-1);
	}
	/* update mtime */
	if ((fd =open_trunc(fn_pending.s)) == -1)
	  fatal("unable to open: ", fn_pending.s);
	if (write(fd, k.s, k.len -1) != k.len -1)
	  fatal("unable to write: ", fn_pending.s);
	close(fd);
	k.s[32] =0;
        if ((fdmsg =open_read(msg.s)) == -1) fatal("unable to open: ", msg.s);
	inject_qconfirm_msg(fdmsg, k.s, 0, 0);
	strerr_die3x(111, INFO, "remind: ", fn_pending.s);
      }
    }
    defer(fn_pending.s);
  }
  if (errno != error_noent) fatal("unable to open: ", fn_pending.s);

  if (badmailfrom && (mode == MODE_SENDER)) {
    /* check bad/ */
    if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
    if (! stralloc_cats(&sa, "/bad/")) die_nomem();
    if (! stralloc_cat(&sa, &id)) die_nomem();
    if (stat(sa.s, &st) != -1) /* sender is bad */
      strerr_die1x(100, "Sorry, you are in my badmailfrom list.");
    if (errno != error_noent) fatal("unable to stat: ", sa.s);
  
    /* check -default: a-b-default, a-default, default. */
    for (i =id.len; i >= 0; --i) {
      if (! i || (id.s[i -1] == '-')) {
	if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
	if (! stralloc_cats(&sa, "/bad/")) die_nomem();
	if (! stralloc_catb(&sa, id.s, i)) die_nomem();
	if (! stralloc_cats(&sa, "default")) die_nomem();
	if (! stralloc_0(&sa)) die_nomem();
	if (stat(sa.s, &st) != -1) /* sender is bad */
	  strerr_die1x(100, "Sorry, you are in my badmailfrom list.");
	if (errno != error_noent) fatal("unable to stat: ", sa.s);
      }
    }
    /* check host: a:b:c:d, :b:c:d, :c:d, :d. */
    if (wildhost && ((i =byte_chr(id.s, id.len, '=')) != id.len)) {
      if (! stralloc_copyb(&hostsa, id.s, i)) die_nomem();
      for (i =0; i < hostsa.len; ++i) {
	if ((hostsa.s[i] == ':') || ! i) {
	  if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
	  if (! stralloc_cats(&sa, "/bad/")) die_nomem();
	  if (! stralloc_catb(&sa, hostsa.s +i, hostsa.len -i)) die_nomem();
	  if (! stralloc_0(&sa)) die_nomem();
	  if (stat(sa.s, &st) != -1) /* sender is bad */
	    strerr_die1x(100, "Sorry, you are in my badmailfromhosts list.");
	  if (errno != error_noent) fatal("unable to stat: ", sa.s);
	}
      }
    }
  }
  if (prog) {
    /* run prog */
    int pid;
    int wstat;

    if (! pathexec_env("QCONFIRM_DIR", qconfirm_dir)) die_nomem();
    if ((pid =fork()) == -1) fatal("unable to fork", 0);
    if (! pid) {
      /* child */
      pathexec(prog);
      fatal("unable to start child: ", (char*) *prog);
    }
    if (wait_pid(&wstat, pid) != pid) fatal("wait_pid", 0);
    if (wait_exitcode(wstat) == 0) ok((char*) *prog);
    if (wait_exitcode(wstat) == 111) defer((char*)*prog);
  }

  if (queuelifetime_expired())
    strerr_die1x(100, "No delivery confirmation received.");

  /* need to request confirmation... create a new key */
  do {
    if (! stralloc_copys(&sa, sender)) die_nomem();
    if (! (key =qconfirm_key(&sa))) die_nomem();
    if (! stralloc_copys(&fn_confirm, ".qmail-")) die_nomem();
    if (str_len(ext) != 0) {
      if (! stralloc_cats(&fn_confirm, ext)) die_nomem();
      if (! stralloc_cats(&fn_confirm, "-")) die_nomem();
    }
    if (! stralloc_cats(&fn_confirm, qconfirm_ext)) die_nomem();
    if (! stralloc_cats(&fn_confirm, key)) die_nomem();
    if (! stralloc_0(&fn_confirm)) die_nomem();
  } while (stat(fn_confirm.s, &st) != -1);

  /* create .qmail-confirm-<key> */
  if (! stralloc_copys(&command, "|")) die_nomem();
  if (! stralloc_cats(&command, qconfirm_accept)) die_nomem();
  if (! stralloc_cats(&command, " '")) die_nomem();
  if (! stralloc_cats(&command, id.s)) die_nomem();
  if (! stralloc_cats(&command, "' '")) die_nomem();
  if (! stralloc_cats(&command, qconfirm_dir)) die_nomem();
  if (qconfirm_accept_prog) {
    if (! stralloc_cats(&command, "' ")) die_nomem();
    if (! stralloc_cats(&command, qconfirm_accept_prog)) die_nomem();
    if (! stralloc_cats(&command, "\n")) die_nomem();
  }
  else
    if (! stralloc_cats(&command, "'\n")) die_nomem();
  if ((fd =open_trunc(fn_confirm.s)) == -1)
    fatal("unable to open: ", fn_confirm.s);
  if (write(fd, command.s, command.len) != command.len) {
    if (unlink(fn_confirm.s) == -1) warn_unlink(fn_confirm.s);
    fatal("unable to write: ", fn_confirm.s);
  }
  close(fd);

  /* create .qconfirm/pending/<id> */
  if (! stralloc_copys(&sa, key)) die_nomem();
  if (! stralloc_append(&sa, " ")) die_nomem();
  if (! stralloc_cats(&sa, inode)) die_nomem();
  if (! stralloc_append(&sa, " ")) die_nomem();
  if (ext) if (! stralloc_cats(&sa, ext)) die_nomem();

  if ((fd =open_trunc(fn_pending.s)) == -1) {
    if (unlink(fn_confirm.s) == -1) warn_unlink(fn_confirm.s);
    fatal("unable to open: ", fn_pending.s);
  }
  if (write(fd, sa.s, sa.len) != sa.len) {
    if (unlink(fn_confirm.s) == -1) warn_unlink(fn_confirm.s);
    if (unlink(fn_pending.s) == -1) warn_unlink(fn_pending.s);
    fatal("unable to write: ", fn_pending.s);
  }
  close(fd);

  /* get mid */
  mid =0;
  while ((i =getline(buffer_0, &sa)) > 0) {
    if ((i == 1) && (sa.s[0] == '\n')) break; /* end of headers */
    for (i =0; i < sa.len; ++i)
      if (sa.s[i] < 32 || sa.s[i] > 126)
	sa.s[i] ='.';
      else {
	x =sa.s[i] -'A';
	if (x <= 'Z' -'A') sa.s[i] =x +'a';
      }
    if ((sa.len > 12) && str_start(sa.s, "message-id")) {
      for (s =sa.s +10; (*s == ' ') || (*s == '\t'); ++s) ;
      if (*s != ':') continue;
      for (++s; (*s == ' ') || (*s == '\t'); ++s) ;
      if (*s++ != '<') continue;
      mid =s;
      for (; *s && (*s != '>'); ++s) ;
      if (! *s || (s == mid)) {
	mid =0;
	continue;
      }
      *s =0;
      break;
    }
  }
  if (seek_begin(0) == -1) fatal("unable to seek: ", "stdin");

  /* inject confirmation request */
  if ((fdmsg =open_read(msg.s)) == -1) {
    if (unlink(fn_confirm.s) == -1) warn_unlink(fn_confirm.s);
    if (unlink(fn_pending.s) == -1) warn_unlink(fn_pending.s);
    fatal("unable to open: ", msg.s);
  }
  if (inject_qconfirm_msg(fdmsg, key, mid, 0) == -1) {
    if (unlink(fn_confirm.s) == -1) warn_unlink(fn_confirm.s);
    if (unlink(fn_pending.s) == -1) warn_unlink(fn_pending.s);
    fatal("unable to inject: ", "confirmation request");
  }

  strerr_die3x(111, INFO, "Waiting for confirmation: ", fn_pending.s);
  return(111);
}
