#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "qconfirm.h"
#include "qconfirm_conf_get.h"
#include "qconfirm_id.h"
#include "error.h"
#include "sig.h"
#include "stralloc.h"
#include "strerr.h"
#include "sgetopt.h"
#include "buffer.h"
#include "env.h"
#include "seek.h"
#include "byte.h"
#include "str.h"
#include "open.h"
#include "getline.h"

#define USAGE " [-va] [ mid ... ]"
#define VERSION "$Id: qconfirm-check-mid.c,v 1.10 2004/03/15 19:08:14 pape Exp $"
#define FATAL "qconfirm-check-mid: fatal: "
#define WARNING "qconfirm-check-mid: warning: "
#define INFO "qconfirm-check-mid: info: "

const char *progname;

void usage() { strerr_die4x(111, "usage: ", progname, USAGE, "\n"); }
void die_nomem() { strerr_die2x(111, FATAL, "out of memory."); }
void fatal(char *m0, char *m1) { strerr_die4sys(111, FATAL, m0, m1, ": "); }
void warn(char *m0, char *m1) {
  strerr_warn4(WARNING, m0, m1, ": ", &strerr_sys);
}
void info(char *m0, char *m1) {
  buffer_puts(buffer_1, INFO); buffer_puts(buffer_1, m0);
  buffer_puts(buffer_1, ": "); buffer_puts(buffer_1, m1);
  buffer_putsflush(buffer_1, "\n");
}
void die(int rc) {
  if (seek_begin(0) == -1) fatal("unable to seek: ", "stdin");
  _exit(rc);
}

unsigned int accept =0;
unsigned int verbose =0;
char *sender;
char *qconfirm_dir;
char *qconfirm_mid;
char **mids;
stralloc line ={0};
stralloc id ={0};
stralloc fn ={0};

const char *midmatch(void) {
  char *s =line.s;
  int slen =line.len;
  int len;
  int i;
  char **m;
  char *p;

  while (slen && (i =byte_chr(s, slen, '>')) < slen) {
    if (*qconfirm_mid) {
      p =qconfirm_mid;
      for(;;) {
	if (! (len =str_chr(p, ' '))) break;
	if (byte_diff(p, len, s +i -len) == 0) {
	  p[len] =0;
	  return(p);
	}
	if (p[len] == 0) break;
	p +=len +1;
      }
    }
    for (m =mids; m && *m; ++m) {
      len =str_len(*m);
      if (len > i) continue;
      if (byte_diff(*m, len, s +i -len) == 0) return(*m);
    }
    ++i; s +=i; slen -=i;
  }
  return(0);
}

void accept_sender(void) {
  int fd;

  if (address2id(&id, sender) == -1) die_nomem();
  if (! stralloc_copys(&fn, qconfirm_dir)) die_nomem();
  if (! stralloc_cats(&fn, "/ok/")) die_nomem();
  if (! stralloc_cat(&fn, &id)) die_nomem();
  if ((fd =open_trunc(fn.s)) == -1)
    warn("unable to create: ", fn.s);
  else
    if (verbose) info("accept", sender);
  close(fd);
}

int main(int argc, char **argv) {
  int opt;
  int i;
  unsigned char x;
  const char *m;
  char *h =0;
  char *p;

  progname =*argv;
  umask(0177);
  sig_ignore(sig_pipe);

  qconfirm_dir =env_get("QCONFIRM_DIR");
  qconfirm_mid =env_get("QCONFIRM_MID");

  while ((opt =getopt(argc, (const char **)argv, "Vav")) != opteof) {
    switch(opt) {
    case 'a': accept =1; break;
    case 'v': verbose =1; break;
    case 'V': strerr_warn1(VERSION, 0);
    case '?': usage();
    }
  }
  argv +=optind;

  /* lowercase mids */
  for(mids =argv; *mids; ++mids)
    for (i =0; (*mids)[i]; ++i) {
      x =(*mids)[i] -'A';
      if (x <= 'Z' -'A') (*mids)[i] =x +'a';
    }
  mids =argv;

  sender =env_get("SENDER");
  if (! sender)
    strerr_die2x(100, FATAL, "environment variable SENDER not set.\n");
  if (! qconfirm_dir) qconfirm_dir =QCONFIRMDIR;
  if (! qconfirm_mid)
    qconfirm_mid =conf_get_dflt(qconfirm_dir, "QCONFIRM_MID", "");
  if (! qconfirm_mid) fatal("unable to read config: ", "QCONFIRM_MID");
  /* lowercase QCONFIRM_MID */
  for (i =0; qconfirm_mid[i]; ++i) {
    x =qconfirm_mid[i] -'A';
    if (x <= 'Z' -'A') qconfirm_mid[i] =x +'a';
  }

  while ((i =getline(buffer_0, &line)) > 0) {
    if ((i == 1) && (line.s[0] == '\n')) break; /* end of headers */
    /* lowercase line */
    for (i =0; i < line.len; ++i) {
      x =line.s[i] -'A';
      if (x <= 'Z' -'A') line.s[i] =x +'a';
    }
    if ((line.s[0] == ' ') || (line.s[0] == '\t')) {
      if (h && (m =midmatch())) {
	info(h, (char*)m);
	if (accept) accept_sender();
	die(0);
      }
      continue;
    }
    else h =0;
    if ((line.len > 13) && str_start(line.s, "in-reply-to")) {
      for (p =line.s +11; (*p == ' ') || (*p == '\t'); ++p) ;
      if (*p != ':') continue;      
      h ="in-reply-to";
      if ((m =midmatch())) {
	info(h, (char*)m);
	if (accept) accept_sender();
	die(0);
      }
    }
    if ((line.len > 12) && str_start(line.s, "references")) {
      for (p =line.s +10; (*p == ' ') || (*p == '\t'); ++p) ;
      if (*p != ':') continue;      
      h ="references";
      if ((m =midmatch())) {
	info(h, (char*)m);
	if (accept) accept_sender();
	die(0);
      }
    }
  }
  if (i == -1) die_nomem();
  if (verbose) info("unknown", "no known references");
  die(100);
  return(100);
}
