#include "buffer.h"
#include "stralloc.h"
#include "byte.h"

int getline(buffer *b, stralloc *line) {
  int r, i;
  char *x;

  if (! stralloc_copys(line, "")) return(-1);
  for (;;) {
    r =buffer_feed(b);
    if (r <= 0) return r;
    x =buffer_peek(b);
    if ((i =byte_chr(x, r, '\n')) == r) {
      if (! stralloc_catb(line, x, r)) return(-1);
      buffer_seek(b, r);
      continue;
    }
    if (! stralloc_catb(line, x, i +1)) return(-1);
    buffer_seek(b, i +1);
    return(line->len);
  }
  return(-1);
}
